# Load the model

from Modeling import ModelSet
import os, warnings, StringIO, traceback
from model_Mortal import model_src
try:
  if ModelSet.defaultModelSet().modelNamed("Mortal") is None:
    ModelSet.defaultModelSet().addModelFromXML({'string': model_src})
    model=ModelSet.defaultModelSet().modelNamed('Mortal')
except:
  exc=StringIO.StringIO()
  traceback.print_exc(file=exc)
  warnings.warn("Couldn't load model 'model_Mortal.xml'\nReason:\n%s"%exc.getvalue())
  del exc

del os, warnings, StringIO, traceback, model_src

# Or, alternatively: use the xml file (ok for dev. mode, not for install w/
# distutils)
#
# from Modeling import ModelSet
# import os, warnings, StringIO, traceback
# try:
#   if ModelSet.defaultModelSet().modelNamed("Mortal") is None:
#     from os import getcwd, path
#     mydir = os.path.abspath(os.path.dirname(__file__))
#     xmlmodelPath=path.join(mydir,'model_Mortal.xml')
#     ModelSet.defaultModelSet().addModelFromXML({'file': xmlmodelPath})
#     model=ModelSet.defaultModelSet().modelNamed('Mortal')
# except:
#   exc=StringIO.StringIO()
#   traceback.print_exc(file=exc)
#   warnings.warn("Couldn't load model 'model_Mortal.xml'\nReason:\n%s"%exc.getvalue())
#   del exc
# 
# del os, warnings, StringIO, traceback
