package com.apropobenefits.wicket.component.paging;

import wicket.contrib.dataview.DataView;
import wicket.markup.html.basic.Label;
import wicket.markup.html.link.Link;
import wicket.markup.html.panel.Panel;

/**
 * A base paging class which adds the first, previous, next, and last links
 * around whatever page navigation or label is being displayed.
 * 
 * @author Phil Kulak
 */
public abstract class AbstractPageNav extends Panel {
	private DataView dataView;
	
	public AbstractPageNav(String id, DataView dataView, PagingConfig config) {
		super(id);
		this.dataView = dataView;
		
		add(new Link("newest") {
			@Override
			public void onClick() {
				getDataView().setCurrentPage(0);
			}
			
			@Override
			public boolean isVisible() {
				return getDataView().getCurrentPage() > 1;
			}
		}.add(new Label("first", config.getFirst())));
		
		add(new Link("newer") {
			@Override
			public void onClick() {
				getDataView().setCurrentPage(getDataView().getCurrentPage() - 1);
			}
			
			@Override
			public boolean isVisible() {
				return getDataView().getCurrentPage() > 0;
			}
		}.add(new Label("previous", config.getPrevious())));
		
		add(new Link("older") {
			@Override
			public void onClick() {
				getDataView().setCurrentPage(getDataView().getCurrentPage() + 1);
			}
			
			@Override
			public boolean isVisible() {
				return getDataView().getCurrentPage() + 1 < getTotalPages();
			}
		}.add(new Label("next", config.getNext())));
		
		add(new Link("oldest") {
			@Override
			public void onClick() {
				getDataView().setCurrentPage(getTotalPages() - 1);
			}
			
			@Override
			public boolean isVisible() {
				return getDataView().getCurrentPage() + 2 < getTotalPages();
			}
		}.add(new Label("last", config.getLast())));
	}
	
	public DataView getDataView() {
		return dataView;
	}
	
	protected int getTotalPages() {
		return (int) Math.ceil(((double) dataView.getItemCount()) / dataView.getRowsPerPage());
	}
}
