package com.apropobenefits.wicket.component.paging;

import wicket.Component;
import wicket.contrib.dataview.DataView;
import wicket.markup.html.basic.Label;
import wicket.model.Model;

/**
 * A page navigation menu ripped off from... er... inspired by Gmail.
 * 
 * @author Phil Kulak
 */
public class GmailPageNav extends AbstractPageNav {
	private static final String OPEN_BOLD = "<span style=\"font-weight: bold\">";
	private static final String CLOSE_BOLD = "</span>";

	public GmailPageNav(String id, DataView dataView, PagingConfig config) {
		super(id, dataView, config);
		
		add(new Label("pageLabel", new Model() {
			@Override
			public Object getObject(Component component) {
				return getPageLabel();
			}
		}).setEscapeModelStrings(false));
	}
	
	private String getPageLabel() {
		int first;
		DataView dataView = getDataView();
		
		if (dataView.getCurrentPage() == -1) {
			first = 0;
		} else {
			first = dataView.getCurrentPage() * dataView.getRowsPerPage() + 1;
		}
		
		int last = dataView.getItemCount() >= first + dataView.getRowsPerPage()
			? first + dataView.getRowsPerPage() - 1
			: dataView.getItemCount();
		
		int total = dataView.getItemCount();
		
		return OPEN_BOLD + first + " - " + last + CLOSE_BOLD +" of " + 
			OPEN_BOLD + total + CLOSE_BOLD;
	}

}
