package com.apropobenefits.wicket.component.paging;

/**
 * A configuration file used by an implementor of AbstractPageNav.
 * 
 * @author Phil Kulak
 */
public class PagingConfig {
	private String first;
	private String previous;
	private String next;
	private String last;
	
	public static final PagingConfig MINIMAL = new PagingConfig("","","","");
	
	public static final PagingConfig STANDARD = new PagingConfig(
		"First", "Previous", "Next", "Last");
	
	public static final PagingConfig GMAIL = new PagingConfig(
		"Newest", "Newer", "Older", "Oldest");
	
	public PagingConfig(String first, String previous, String next, String last) {
		this.first = first;
		this.previous = previous;
		this.next = next;
		this.last = last;
	}
	
	public String getFirst() {
		return first;
	}
	
	public String getLast() {
		return last;
	}
	
	public String getNext() {
		return next;
	}
	
	public String getPrevious() {
		return previous;
	}
}
