package com.apropobenefits.wicket.component.paging;

import wicket.AttributeModifier;
import wicket.contrib.dataview.DataView;
import wicket.markup.html.basic.Label;
import wicket.markup.html.list.Loop;
import wicket.markup.html.navigation.paging.IPageable;
import wicket.markup.html.navigation.paging.PagingNavigation;
import wicket.markup.html.navigation.paging.PagingNavigationLink;
import wicket.model.Model;

/**
 * A page navigator that uses a stardard numeric page listing.
 * 
 * @author Phil Kulak
 */
public class StandardPageNav extends AbstractPageNav {
	public StandardPageNav(String id, DataView dataView, PagingConfig config) {
		super(id, dataView, config);
		add(new NumericPageNav("nav", getDataView()));
	}
	
	private static class NumericPageNav extends PagingNavigation {
		public NumericPageNav(String id, IPageable pageable) {
			super(id, pageable);
		}
		
		@Override
		protected void populateItem(Loop.LoopItem loopItem) {
			int page = getStartIndex() + loopItem.getIteration();

			PagingNavigationLink link = new PagingNavigationLink("pageLink", pageable, page);
			
			// Set the surrounding tags when this link is active.
			link.setBeforeDisabledLink("<span class=\"activePage\">[");
			link.setAfterDisabledLink("]</span>");
			
			// And a class atribute to the anchor tag.
			link.add(new AttributeModifier("class", true, new Model("pageLink")));
			
			link.add(new Label("pageNumber", String.valueOf(page + 1)));
			loopItem.add(link);
		}
		
		@Override
		public boolean isVisible() {
			int pageCount = pageable.getPageCount();
			int currentPage = pageable.getCurrentPage();
			return pageCount > 1 || currentPage > pageCount - 1;
		}
	}
}
