

#ifndef __MENU_HEADER__
#define __MENU_HEADER__
//*****************************************************************************

#include <gtk/gtk.h>

//*****************************************************************************

#define ETHERNET_DEVICE_NAME_MAX_SIZE 512

#define HOST_ADDRESS_LEN 64

typedef int Status_e;

#define FRAME_NEW(w, Id) { \
	w = gtk_frame_new((Id)); \
	}

#define LABEL_NEW(w, Id) { \
	w = gtk_label_new((Id)); \
	}

#define LABEL_SET(w, text) { \
	gchar * pString = g_locale_to_utf8(text, -1, NULL, NULL, NULL); \
	gtk_label_set_text(GTK_LABEL((w)), (pString)); \
	g_free(pString); \
	}


/*!
 * Cette macro permet d'ajouter un sous menu  un menu.
 * \param Menu Pointeur sur le menu.
 * \param SubMenu Pointeur sur le sous menu.
 * \param Name Nom du menu.
 */
#define MenuAddNew(Menu, SubMenu, Name) {					\
	GtkWidget * pItem;										\
	(SubMenu) = gtk_menu_new();									\
	pItem = gtk_menu_item_new_with_label((Name));				\
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(pItem), (SubMenu));\
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), pItem);		\
}

/*!
 * Cette macro permet d'ajouter des items  un menu.
 * \param Menu Pointeur sur le sous menu.
 * \param ItemName Nom de l'item.
 * \param CallBack Callback  excuter.
 * \param Param Paramtre  passer  la callback.
 * \param pItem Pointeur sur l'item cr
 */
#define MenuAddNewItem(Menu, ItemName, CallBack, Param, pItem) {\
	pItem = gtk_image_menu_item_new_from_stock((ItemName), NULL);			\
	g_signal_connect(G_OBJECT(pItem), "activate", G_CALLBACK(CallBack), (Param));	\
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), pItem);						\
}

/*!
 * Cette macro permet d'ajouter un sparateur  un menu.
 * \param Menu Pointeur sur le sous menu.
 */
#define MenuAddSeparator(Menu) {						\
	GtkWidget * pItem;									\
	pItem = gtk_separator_menu_item_new();				\
	gtk_menu_shell_append(GTK_MENU_SHELL(Menu), pItem);	\
}

typedef struct AppCnfCapture{
	/*! Nom de l'quipement ethernet */
	char EthDeviceName[ETHERNET_DEVICE_NAME_MAX_SIZE];

	Status_e InfoEnabled;
} AppCnfCapture_t;


//*****************************************************************************

void MenuCreate(GtkWidget * pBox);

//*****************************************************************************
#endif
