
#ifdef _WIN32
	#include <windows.h>
#endif

#include <glib.h>
#include <direct.h>
#include <gtk/gtk.h>

#include "Menu.h"

#define END_OF_MESSAGE "\n\n"

//*****************************************************************************

#ifdef _WINDOWS
int main(int argc, char ** argv);
#endif


#ifdef _WINDOWS
int _stdcall
WinMain (struct HINSTANCE__ *hInstance,
	 struct HINSTANCE__ *hPrevInstance,
	 char               *lpszCmdLine,
	 int                 nCmdShow)
{
	return main (__argc, __argv);
}
#endif

//*****************************************************************************

GtkWidget * pWindow = NULL;
static GtkWidget * pNotebook = NULL;
static GtkWidget * pVBox = NULL;

//*****************************************************************************

static void OnMainQuit(void);
static gint OnMainExit(void);

//*****************************************************************************

int main(int argc, char ** argv)
{
	if (!g_thread_supported ()) g_thread_init(NULL);

	gtk_init(&argc,&argv);

	pWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_position(GTK_WINDOW(pWindow), GTK_WIN_POS_CENTER);
	gtk_widget_add_events(GTK_WIDGET(pWindow), GDK_CONFIGURE);

	gtk_widget_set_size_request(pWindow, 800, 600);

	g_signal_connect(G_OBJECT(pWindow), "delete-event", G_CALLBACK(OnMainQuit), NULL);

	pVBox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(pWindow), pVBox);

	MenuCreate(pVBox);

	gtk_widget_show_all(pWindow);

	gtk_main();

	return EXIT_SUCCESS;
}

//*****************************************************************************

static gint OnMainExit(void)
{
	gtk_main_quit();

	return FALSE;
}

//*****************************************************************************

static void OnMainQuit(void)
{
	g_idle_add_full(GTK_PRIORITY_HIGH,(GtkFunction)OnMainExit, NULL, NULL);
}

//*****************************************************************************
