//============================================================================
// Name        : bugreport.cpp
// Author      : s.b.
// Version     :
// Copyright   : Your copyright notice
// Description : Hello World in C, Ansi-style
//============================================================================

#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WComboBox>
#include <Wt/WLineEdit>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WGridLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WHBoxLayout>
#include <Wt/WTable>
#include <Wt/WDialog>

#include <iostream>
#include <string>
#include <vector>

using namespace std;
using namespace Wt;

/*
 * A simple hello world application class which demonstrates how to react
 * to events, read input, and give feed-back.
 */
class BugApplication :  public WContainerWidget
{
	WComboBox *m_region;
	WComboBox *m_locality;
	WComboBox *m_district;
	WPushButton *m_ok;
	WPushButton *m_pButton;
	WDialog *m_dialog;
public:
	BugApplication(WContainerWidget *parent);
	~BugApplication();
public slots:
	void invokeDialog();
	void setDistrictList(int);
	void setLocalityList(int);


};

BugApplication::~BugApplication()
{

}


BugApplication::BugApplication(WContainerWidget *parent)
  : WContainerWidget(parent)
{

	m_pButton = new WPushButton ("Dialog with WComboBox",this);
	m_pButton->clicked.connect(SLOT(this,BugApplication::invokeDialog ));


}

void BugApplication::invokeDialog()
{
	m_dialog = new WDialog("Dialog with WComboBox");

	WContainerWidget *dialog_container = new WContainerWidget(m_dialog->contents());
	m_region = new WComboBox(dialog_container);
	m_region->addItem("Region_1");
	m_region->addItem("Region_2");
	new WBreak(dialog_container);

	m_district = new WComboBox(dialog_container);
	m_district->addItem("District");
	new WBreak(dialog_container);

	m_locality = new WComboBox(dialog_container);
	m_locality->addItem("Locality");
	m_ok = new WPushButton("Ok", dialog_container);
	m_ok->clicked.connect(SLOT(m_dialog, WDialog::reject));


	m_region->activated.connect(SLOT(this,BugApplication::setDistrictList));
	m_district->activated.connect(SLOT(this,BugApplication::setLocalityList));

	if (m_dialog->exec() == WDialog::Accepted) {
				   //setStatus("Welcome, " + edit.text());
	}
}





void BugApplication::setDistrictList(int item)
{
	cout << "BugApplication::setDistrictList: \n";
	m_district->clear();

	m_district->addItem("District_1");
	m_district->addItem("District_2");

	//================================================
	//if (item==0){
	//	cout << "Regions_1's Districts Added\n";
	//	m_district->addItem("Region_1 District_1");
	//	m_district->addItem("Region_1 District_2");
	//}
	//if (item==1){
	//		cout << "Regions_2's Districts Added\n";
	//		m_district->addItem("Region_2 District_1");
	//		m_district->addItem("Region_2 District_2");
	//	}
	//=================================================


	m_district->refresh();

}

void BugApplication::setLocalityList(int item)
{
	cout << "BugApplication::setLocalityList():"<<endl;
	m_locality->clear();

	m_locality->addItem("Locality_1");
	m_locality->addItem("Locality_2");

	//====================================================
    //	if (item==0){
	//		cout << "District_1's Localitys Added\n";
	//		m_locality->addItem("District_1 Locality_1");
	//		m_locality->addItem("District_1 Locality_2");

	//	}
	//	if (item==1){
	//		cout << "District_2's Localitys Added\n";
	//		m_locality->addItem("District_2 Locality_1");
	//		m_locality->addItem("District_2 Locality_2");
	//}
	//=====================================================


	m_locality->refresh();
}


WApplication *createApplication(const WEnvironment& env)
{
  	WApplication *app = new WApplication(env);
	new BugApplication (app->root());
	return app;
}

int main(int argc, char **argv)
{
  return WRun(argc, argv, &createApplication);
}

