#include "Gui.h"
#include "Server.h"
#include <Wt/WString> 
#include <Wt/WPushButton> 
#include <string> 
using namespace Wt;

extern Server server;

Gui::Gui(WContainerWidget* parent)
  : WContainerWidget(parent),
    app_((Test*)(WApplication::instance())),
    tree_(0),
    model_(0)
{
  WPushButton* button = new WPushButton("Reset model via enableUpdates()!");
  button->clicked().connect(SLOT(this, Gui::emitUpdateEvent));
  addWidget(button);
  tree_ = new WTreeView;
  tree_->setModel(model_ = dummyModel());
  addWidget(tree_);
  server.updateEvent().connect(SLOT(this, Gui::processUpdateEvent)); 
}

Gui::~Gui()
{
  if (!model_) {
    delete model_;
    model_ = 0;
  } 
}

WStandardItemModel* Gui::dummyModel()
{
  WStandardItemModel* result = new WStandardItemModel(3, 2);
  result->setHeaderData(0, boost::lexical_cast<std::string>("foo"));
  result->setHeaderData(1, boost::lexical_cast<std::string>("bar"));
  return result;
}

void Gui::emitUpdateEvent()
{
  server.emitUpdateEvent();
}

void Gui::processUpdateEvent()
{
  WApplication::UpdateLock lock = app_->getUpdateLock();
  updateTree();
  app_->triggerUpdate();
}

void Gui::updateTree()
{
  WStandardItemModel* old = model_;
  tree_->setModel(dummyModel());
  delete old;
}

