
#include <Wt/WApplication>

#include <Wt/WContainerWidget>
#include <Wt/WGridLayout>
#include <Wt/WHBoxLayout>
#include <Wt/WVBoxLayout>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <iostream>

class App: public Wt::WApplication
{
  private:
    int counter;
    Wt::WContainerWidget* widget;
    Wt::WContainerWidget* cont;
    Wt::WVBoxLayout* layout;
    
    void changeMiddleContainer()
    {
      char const* style = 0;
      switch( counter % 3 )
      {
        case 0:
        {
          style = "Red";
          break;
        }
        case 1:
        {
          style = "Green";
          break;
        }
        case 2:
        {
          style = "Blue";
          break;
        }
      }
      layout->removeWidget( widget );
      delete widget;

      widget = new Wt::WContainerWidget();
      widget->setStyleClass( style );
      layout->addWidget( widget, 1 );

      widget->addWidget( new Wt::WText( "Some text." ) );

      ++counter;
    }

  public:
    App( Wt::WEnvironment const& env ):
      Wt::WApplication( env ),
      counter( 0 ),
      widget( 0 ),
      cont( 0 ),
      layout( 0 )
    {
      useStyleSheet( "style.css" );

      Wt::WGridLayout* mlayout = new Wt::WGridLayout();
      root()->setLayout( mlayout );

      Wt::WPushButton* btn = new Wt::WPushButton( "Change" );
      mlayout->addWidget( btn, 1, 0  );
      btn->clicked().connect( this, &App::changeMiddleContainer );

      mlayout->addWidget( new Wt::WText( "TopLeft" ), 0, 0 );
      mlayout->addWidget( new Wt::WText( "TopRight" ), 0, 1 );

      cont = new Wt::WContainerWidget();
      mlayout->addWidget( cont, 1, 1 );

      layout = new Wt::WVBoxLayout();
      cont->setLayout( layout );

      widget = new Wt::WContainerWidget();
      layout->addWidget( widget, 1 );
      widget->setStyleClass( "Blue" );

      mlayout->setColumnStretch( 1, 1 );
      mlayout->setRowStretch( 1, 1 );
    }
};

Wt::WApplication* createApp( Wt::WEnvironment const& env )
{
  return new App( env );
}

int main( int argc, char** argv )
{
  return Wt::WRun( argc, argv, &createApp );
}

