
#include "PaintedW.h"

#include <iostream>

PaintedW::PaintedW():
  w( 100 ),
  h( 100 )
{
  setId( "PaintedW" );
  setStyleClass( "PW" );

  setMinimumSize( 100, 100 );
#ifdef WORKING_EXAMPLE3
  setMaximumSize( Wt::WLength::Auto, 100 );
  resize( 100, 100 );
#else
  setLayoutSizeAware( true );
#endif
}

void PaintedW::layoutSizeChanged( int pWidth, int pHeight )
{
  std::cout << "layoutSizeChanged( " << pWidth << ", " << pHeight << " )\n";
  w = pWidth;
  h = pHeight;
  Wt::WPaintedWidget::layoutSizeChanged( pWidth, pHeight );
}

void PaintedW::paintEvent( Wt::WPaintDevice* pPaintDevice )
{
  std::cout << "paintEvent( .. )\n";
  /*
  std::cout << "  width:  " << width().toPixels() << "\n"
            << "  height: " << height().toPixels() << "\n";
  std::cout << " +width:  " << w << "\n"
            << " +height: " << h << "\n";
  */

  Wt::WPainter painter( pPaintDevice );

  Wt::WPen pen( Wt::WColor( 0, 0, 0 ) );
  painter.setPen( pen );

  painter.drawLine( 0, 0, w, h );
}

