
#include "app.h"
#include "PaintedW.h"

#include <Wt/WContainerWidget>
#include <Wt/WVBoxLayout>
#include <Wt/WText>

#include <iostream>

#include <QtCore/QThread>
#undef emit
#undef signals

class Updater: public QThread
{
  private:
    App* mApp;

  public:
    Updater( App* app ):
      QThread(),
      mApp( app )
    {
    }

    virtual ~Updater()
    {
    }

    virtual void run()
    {
      int const t = 2000;
      std::cout << "Thread sleeping for " << t << " milliseconds before adding widget.\n";
      msleep( t );

      {
        std::cout << "Ackquiring update lock.\n";
        Wt::WApplication::UpdateLock l = mApp->getUpdateLock();
        std::cout << "Adding widget from other thread.\n";
        mApp->addPaintedWidget();
        std::cout << "Triggering update\n";
        mApp->triggerUpdate();
        std::cout << "Done\n";
      }
    }
};

App::App( Wt::WEnvironment const& env ):
  Wt::WApplication( env )
{
  std::cout << "\n\nNew Session created.\n";
  enableUpdates();

  layout = new Wt::WVBoxLayout();
  root()->setLayout( layout );

#ifdef WORKING_EXAMPLE1
  addPaintedWidget();
#else
  Updater* u = new Updater( this );
  u->start();
#endif
}

App::~App()
{
}

void App::addPaintedWidget()
{
  std::cout << "App::addPaintedWidget()\n";

#ifdef WORKING_EXAMPLE2
  Wt::WText* w = new Wt::WText( "Hello World!" );
#else
  PaintedW* w = new PaintedW();
#endif
  layout->addWidget( w, -1 );
  layout->addStretch( 1 );
}

