<xsl:stylesheet
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   version="1.0"
>
<xsl:output method="xml"/>
<!--
	ConvertSciToNumString 
	By: 	Michael Case
		University of California, Davis
		case@ucdhep.ucdavis.edu
	REMOVED ALL CHECKING AND OTHER CONDITIONS for potential bug report.
-->

<!-- necessary global maximum/minimum of exponent 'stuffer', set to 100 -->
<xsl:variable name="max-exp">
  <xsl:value-of select="'0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'"/>
</xsl:variable>

<xsl:template name="convertSciToNumString">
  <xsl:param name="myval" select="''"/>
  <xsl:call-template name="realConvertSciToNumString">
    <xsl:with-param name="vnum" select="$myval"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="realConvertSciToNumString" >
  <xsl:param name="vnum" select="0"/>
  <xsl:param name="vsgn" select="''"/>

  <xsl:variable name="vmantisa">
    <xsl:value-of select="number(substring-before($vnum, 'E'))"/>
  </xsl:variable>
  <xsl:variable name="vexponent">
    <xsl:value-of select="number(substring-after($vnum, 'E'))"/>
  </xsl:variable>

  <!-- handle 9.9E9 -->
  <xsl:if test="$vexponent &gt; 0">
    <xsl:variable name="voffset" select="string-length(substring-after($vmantisa, '.'))"/>
    <xsl:variable name="hasdecimal" select="string-length(substring-before($vmantisa, '.'))"/>
    <xsl:choose>
    
      <!-- handle with decimal place -->
      <xsl:when test="$voffset != 0 or $hasdecimal != 0">
        <xsl:value-of select="concat($vsgn, substring-before($vmantisa, '.'), substring-after($vmantisa, '.'), substring($max-exp, 1, ($vexponent - $voffset)))"/>
      </xsl:when>

      <!-- handle when no decimal -->
      <xsl:when test="$voffset == 0 and $hasdecimal == 0">
        <xsl:value-of select="concat($vsgn, $vmantisa,  substring($max-exp, 1, $vexponent))"/>
      </xsl:when>
    </xsl:choose>
  </xsl:if>
 
</xsl:template>

</xsl:stylesheet>
