//package javax.xml.transform.ptests;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.*;
//import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

import org.xml.sax.SAXException;

import org.w3c.dom.*;
import org.apache.xerces.util.*;
import java.io.FileOutputStream;
import java.io.File;
import java.io.IOException;
import  org.apache.xml.serialize.OutputFormat;
import  org.apache.xml.serialize.Serializer;
import  org.apache.xml.serialize.SerializerFactory;
import  org.apache.xml.serialize.XMLSerializer;
import  java.io.*;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.DOMParser;

import org.w3c.dom.Document;
import org.w3c.dom.Text;


/** This tests the DOCTYPE declaration correctness in transformed file */

public class DoctypeTest {
	static DocumentBuilderFactory dbf = null;
	static  DOMParser parser ;
    public static void main(String[] argv) {

	try {
		String xsdFile=(String)argv[0];
		String parseFile=(String)argv[1];
	    
		parser = new DOMParser();
		parser.setFeature("http://xml.org/sax/features/validation",true);
		parser.setFeature("http://xml.org/sax/features/namespaces",true);
		parser.setFeature("http://apache.org/xml/features/validation/schema",true);
		parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking",true);
		parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion",false);
		parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error",true);
		ErrorHandler eh = new ErrorHandler();
		parser.setErrorHandler(eh);
		parser.parse(parseFile);
		
	} catch (SAXException e) {
	    e.printStackTrace();
	    System.exit(0);
	} catch (IOException e) {
	    e.printStackTrace();
	    System.exit(0);
	}

    }// end of main()
	protected static class ErrorHandler extends DefaultHandler { 
		public int errorCounter = 0;

		public void error(SAXParseException e) throws SAXException {
			e.printStackTrace();
			System.out.println("Venu Error is "+e.getMessage());
			errorCounter++;
		}

		public void fatalError(SAXParseException e) throws SAXException { 
			System.out.println("Venu Error is: "+e.getMessage());
			Element node = (Element)parser.getProperty("http://apache.org/xml/properties/dom/current-element-node");
			if (node != null) {
			    // now you have the node from where you can
				    // traverse all the way back to the root
					System.out.println("Venu Current Node is"+node.getNodeName());
				    System.out.println("Venu Parent Node"+node.getParentNode().getNodeName());
			}else
				System.out.println("Node is Null");
			//e.printStackTrace();
			errorCounter++;
		}
	}

}//End of class
