
import javax.xml.parsers.*;
import org.xml.sax.*;
import java.io.*;
import org.w3c.dom.Document;
import org.w3c.dom.DOMException;
import java.util.*;
import java.io.IOException;
import  org.apache.xml.serialize.OutputFormat;
import  org.apache.xml.serialize.Serializer;
import  org.apache.xml.serialize.SerializerFactory;
import  org.apache.xml.serialize.XMLSerializer;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.apache.xerces.xni.*;
import org.xml.sax.SAXException;
import org.apache.xerces.xni.parser.*;
import org.w3c.dom.*;
import org.apache.xerces.util.*;
import java.io.FileOutputStream;

public class Tracer extends DOMParser {

    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String NOTIFY_CHAR_REFS_FEATURE_ID="http://apache.org/xml/features/scanner/notify-char-refs";

    protected static final String DEFAULT_PARSER_CONFIG = "org.apache.xerces.parsers.IntegratedParserConfiguration";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = true;
    protected static final boolean DEFAULT_NOTIFY_CHAR_REFS = false;
    protected NamespaceContext fNamespaceContext;
	

    static Document document;
    static DOMParser parser ;
    public int errorCounter=0;
    public int fatalerrorCounter=0;

    public Tracer (XMLParserConfiguration config){
    super(config);
    //ErrorHandler eh = new ErrorHandler();
    }

     public void startDocument(XMLLocator locator, String encoding,
                              NamespaceContext namespaceContext, Augmentations augs)
        throws XNIException {
		super.startDocument(locator,encoding,namespaceContext,augs);
        fNamespaceContext = namespaceContext;
        System.out.println("Inside Start XML Document");

     }

    public void xmlDecl(String version, String encoding,
                        String standalone, Augmentations augs) throws XNIException {
		super.xmlDecl(version,encoding,standalone,augs);
        System.out.println("Inside XML Declaration");
    }

    public void doctypeDecl(String rootElement, String publicId,
                            String systemId, Augmentations augs) throws XNIException {
			super.doctypeDecl(rootElement,publicId,systemId,augs);
         System.out.println("Inside DOCtype Declaration");
    }


    public void startElement(QName element, XMLAttributes attributes, Augmentations augs)
        throws XNIException {
			super.startElement(element,attributes,augs);
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs)
        throws XNIException {
		super.emptyElement(element,attributes,augs);
    }


    public void characters(XMLString text, Augmentations augs) throws XNIException {
		super.characters(text,augs);
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
		super.ignorableWhitespace(text,augs);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
		super.endElement(element,augs);
    }

    public void startCDATA(Augmentations augs) throws XNIException {
		super.startCDATA(augs);
    }

    public void endCDATA(Augmentations augs) throws XNIException {
		super.endCDATA(augs);
    }

    public void startGeneralEntity(String name,
                                   XMLResourceIdentifier identifier,
                                   String encoding, Augmentations augs)
        throws XNIException {
		super.startGeneralEntity(name,identifier,encoding,augs);

    }


    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
	super.textDecl(version,encoding,augs);
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
		super.comment(text,augs);
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs)
        throws XNIException {
		super.processingInstruction(target,data,augs);
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
		super.endGeneralEntity(name,augs);
    }

    public void endDocument(Augmentations augs) throws XNIException {
		super.endDocument(augs);
    }

    public void startDTD(XMLLocator locator, Augmentations augs) throws XNIException {
		super.startDTD(locator,augs);
        System.out.println("Inside Start DTD");
	
    }
    public void startExternalSubset(XMLResourceIdentifier identifier,
                                    Augmentations augs) throws XNIException {
		super.startExternalSubset(identifier,augs);
    }

    public void endExternalSubset(Augmentations augs) throws XNIException {
		super.endExternalSubset(augs);
    }

    public void ignoredCharacters(XMLString text, Augmentations augs) throws XNIException {
		super.ignoredCharacters(text,augs);
    }

    public void startParameterEntity(String name,
                                     XMLResourceIdentifier identifier,
                                     String encoding, Augmentations augs)
        throws XNIException {
			super.startParameterEntity(name,identifier,encoding,augs);
    }

    public void endParameterEntity(String name, Augmentations augs) throws XNIException {
    }

    public void elementDecl(String name, String contentModel, Augmentations augs)
        throws XNIException {

    }

    public void startAttlist(String elementName, Augmentations augs) throws XNIException {

    }

    public void attributeDecl(String elementName, String attributeName,
                              String type, String[] enumeration,
                              String defaultType, XMLString defaultValue,
                              XMLString nonNormalizedDefaultValue,
                              Augmentations augs) throws XNIException {

   }

    public void endAttlist(Augmentations augs) throws XNIException {

    }

    public void internalEntityDecl(String name, XMLString text,
                                   XMLString nonNormalizedText,
                                   Augmentations augs)
        throws XNIException {

    }

    public void externalEntityDecl(String name,XMLResourceIdentifier identifier, Augmentations augs)
        throws XNIException {

    }

    public void unparsedEntityDecl(String name, XMLResourceIdentifier identifier,
                                   String notation, Augmentations augs) throws XNIException {

    }

    public void notationDecl(String name, XMLResourceIdentifier identifier,
                             Augmentations augs) throws XNIException {

    }

    public void startConditional(short type, Augmentations augs)
        throws XNIException {

    }

    public void endConditional(Augmentations augs) throws XNIException {

    }

    public void endDTD(Augmentations augs) throws XNIException {


    }

    public void startContentModel(String elementName, Augmentations augs)
        throws XNIException {

    }

    public void any(Augmentations augs) throws XNIException {

    }

    public void empty(Augmentations augs) throws XNIException {

    }

    public void startGroup(Augmentations augs) throws XNIException {

    }

    public void pcdata(Augmentations augs) throws XNIException {

    }

    public void element(String elementName, Augmentations augs)
        throws XNIException {

    }

    public void separator(short separator, Augmentations augs)
        throws XNIException {

    }

    public void occurrence(short occurrence, Augmentations augs)
        throws XNIException {

    }

    public void endGroup(Augmentations augs) throws XNIException {

    }

    public void endContentModel(Augmentations augs) throws XNIException {


    }

    public void warning(String domain, String key, XMLParseException ex)
        throws XNIException {
    }


	
     public static void main(String[] argv) throws Exception {

        // is there anything to do?
        if (argv.length == 0) {
            System.out.println ("usage: java Tracer filename");
            System.exit(1);
        }

        //DOMParser parser = null;
        XMLParserConfiguration parserConfig = null;
        boolean namespaces = DEFAULT_NAMESPACES;
        boolean validation = DEFAULT_VALIDATION;
        boolean notifyCharRefs = DEFAULT_NOTIFY_CHAR_REFS;

        String uri = (String) argv[0];
                try {
                    parserConfig = (XMLParserConfiguration)ObjectFactory.newInstance(DEFAULT_PARSER_CONFIG,
                        ObjectFactory.findClassLoader(), true);
                }
                catch (Exception e) {
                    System.err.println("error: Unable to instantiate parser configuration ("+DEFAULT_PARSER_CONFIG+")");
                }

 	parser = new Tracer(parserConfig);

             try {
                parserConfig.setFeature(NAMESPACES_FEATURE_ID, namespaces);
		parserConfig.setFeature("http://apache.org/xml/features/dom/defer-node-expansion",false);
            }
            catch (XMLConfigurationException e) {
                System.err.println("warning: Parser does not support feature ("+NAMESPACES_FEATURE_ID+")");
            }
            try {
                parserConfig.setFeature(VALIDATION_FEATURE_ID, validation);
            }
            catch (XMLConfigurationException e) {
                System.err.println("warning: Parser does not support feature ("+VALIDATION_FEATURE_ID+")");
            }
            try {
                parserConfig.setFeature(NOTIFY_CHAR_REFS_FEATURE_ID, notifyCharRefs);
            }
            catch (XMLConfigurationException e) {
                if (e.getType() == XMLConfigurationException.NOT_RECOGNIZED) {
                    //e.printStackTrace();
                    System.err.println("warning: Parser does not recognize feature ("+NOTIFY_CHAR_REFS_FEATURE_ID+")");
                }
                else {
                    System.err.println("warning: Parser does not support feature ("+NOTIFY_CHAR_REFS_FEATURE_ID+")");
                }
            }

            // parse file
            try {
				parser.setErrorHandler(new ErrorHandler());
                parser.parse(new XMLInputSource(null, uri, null));
            }
            catch (XMLParseException e) {
                // ignore
            }
            catch (Exception e) {
                System.err.println("error: Parse error occurred - "+e.getMessage());
                if (e instanceof XNIException) {
                    e = ((XNIException)e).getException();
                }
                e.printStackTrace(System.err);
            }


    } // main(String[])

	protected static class ErrorHandler extends DefaultHandler { 
		public int errorCounter = 0;

		public void error(SAXParseException e) throws SAXException {
			e.printStackTrace();
			Element node = (Element)parser.getProperty("http://apache.org/xml/properties/dom/current-element-node");
			if (node != null) {
			    // now you have the node from where you can
				    // traverse all the way back to the root
					System.out.println("Venu Current Node is"+node.getNodeName());
				    System.out.println("Venu Parent Node"+node.getParentNode().getNodeName());
			}else{
				System.out.println("Node is Null");
			//e.printStackTrace();
			errorCounter++;
			}
			System.out.println("Venu Error is "+e.getMessage());
		}

		public void fatalError(SAXParseException e) throws SAXException { 
			System.out.println("Venu Error is: "+e.getMessage());
			Element node = (Element)parser.getProperty("http://apache.org/xml/properties/dom/current-element-node");
			if (node != null) {
			    // now you have the node from where you can
				    // traverse all the way back to the root
					System.out.println("Venu Current Node is"+node.getNodeName());
				    System.out.println("Venu Parent Node"+node.getParentNode().getNodeName());
			}else
				System.out.println("Node is Null");
			//e.printStackTrace();
			errorCounter++;
		}
	}

} //Tracer ends














