
import org.apache.xerces.parsers.*;
import org.xml.sax.*;

import java.io.*;

public class Validator implements EntityResolver {

	XMLReader parser = new SAXParser();

	public Validator () throws SAXException {
		parser.setFeature("http://xml.org/sax/features/validation", true);
		parser.setFeature("http://apache.org/xml/features/validation/schema", true);
		//parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);

		//want to resolve schema location indenpendently of what is inside xml file
		parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation",
		                   "http://www.example.com/2002/Declaration Declaration.xsd");

		parser.setEntityResolver(this);
	}

	public InputSource resolveEntity (String publicId, String systemId) throws SAXException, IOException {
		systemId = systemId.substring(systemId.lastIndexOf("/") + 1);
		InputSource source = new InputSource(getClass().getResourceAsStream(systemId));
		source.setSystemId(systemId);
		return source;
	}

	public void validate (String filename) throws IOException, SAXException {
		Reader reader = new InputStreamReader(getClass().getResourceAsStream(filename));
		try {
			InputSource inputSource = new InputSource(reader);
			parser.parse(inputSource);
		} finally {
			reader.close();
		}
	}

	public static void main (String[] args) throws Exception {
		Validator validator = new Validator();
		validator.validate("Declaration.xml");
	}

}
