#!/bin/sh

# $1 ontology filename without extension
#
# We expect to find $1.ontology (ttl file with the ontology), and
# $1.description with the description file (in ttl format)
#
# This script will output $1.trig
#

#
# Checking the number of parameters.
if [ ! $# -eq 1 ]; then
  echo "USAGE: $0 [ONTOLOGY]  (ONTOLOGY.{ontology, description} must exist)"
  exit
fi


ONTOLOGY=$1.ontology
DESCRIPTION=$1.description
TRIG=$1.trig

if [ ! -e $ONTOLOGY ] ; then
   echo "$ONTOLOGY doesn't exist! cannot create TRIG file"
   exit 
fi 

if [ ! -e $DESCRIPTION ] ; then
   echo "$DESCRIPTION doesn't exist! cannot create TRIG file"
   exit 
fi 

if [ -e $TRIG ] ; then
   mv -u $TRIG $TRIG.previous ;
fi

# Merge all prefixes in the both files
grep --no-filename "@prefix" $ONTOLOGY $DESCRIPTION | sort |uniq > $1.trig

echo "\n" >> $TRIG
echo ":metadata {" >> $TRIG
cat $DESCRIPTION |sed s/^/\\t/g |grep -v "@prefix" >> $TRIG
echo "}\n" >> $TRIG
echo ":ontology {" >> $TRIG
cat $ONTOLOGY  |sed s/^/\\t/g  |grep -v "@prefix" >> $TRIG
echo "}\n" >> $TRIG
