#!/bin/sh

# $1 ontology filename without extension
#
# We expect to find $1.ontology (ttl file with the ontology), and
# $1.description with the description file (in ttl format)
#
# This script will output $1.trig
#

#
# Checking the number of parameters.
if [ ! $# -eq 3 ]; then
  echo "USAGE: $0 ONTOLOGY DESCRIPTION TRIG"
  echo "    ONTOLOGY: ontology file in ttl format"
  echo "    DESCRIPTION: metadata about the ontology in ttl format"
  echo "    TRIG: output file, with the two previous files concatenated"
  echo "          in trig format"
  exit
fi


ONTOLOGY=$1
DESCRIPTION=$2
TRIG=$3

if [ ! -e $ONTOLOGY ] ; then
   echo "$ONTOLOGY doesn't exist! cannot create TRIG file"
   exit 
fi 

if [ ! -e $DESCRIPTION ] ; then
   echo "$DESCRIPTION doesn't exist! cannot create TRIG file"
   exit 
fi 

if [ -e $TRIG ] ; then
   mv -u $TRIG $TRIG.previous ;
fi

# Merge all prefixes in the both files
grep --no-filename "@prefix" $ONTOLOGY $DESCRIPTION | sort |uniq > $TRIG
echo "\n\n" >> $TRIG

# Ontology graph
echo ":ontology {" >> $TRIG
cat $ONTOLOGY  |sed s/^/\\t/g  |grep -v "@prefix" >> $TRIG
echo "}\n" >> $TRIG

# Metadata graph
echo ":metadata {" >> $TRIG
cat $DESCRIPTION |sed s/^/\\t/g |grep -v "@prefix" >> $TRIG
echo "}\n" >> $TRIG
