/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml;

public final class Stopwatch {
    String label = null;
    long total = 0L;
    long begin = 0L;
    long end = 0L;

    public Stopwatch() {
    }

    public Stopwatch(boolean bl) {
        if (bl) {
            this.start();
        }
    }

    public Stopwatch(String string) {
        this.label = string;
    }

    public Stopwatch(String string, boolean bl) {
        this.label = string;
        if (bl) {
            this.start();
        }
    }

    public void start() {
        this.begin = System.currentTimeMillis();
    }

    public long stop() {
        this.end = System.currentTimeMillis();
        this.total += this.end - this.begin;
        return this.total;
    }

    public void cancel() {
        this.begin = 0L;
        this.end = 0L;
    }

    public void reset() {
        this.total = 0L;
        this.begin = 0L;
        this.end = 0L;
    }

    public long elapsed() {
        if (this.end != 0L) {
            return this.end - this.begin;
        }
        return System.currentTimeMillis() - this.begin;
    }

    public long total() {
        if (this.end != 0L) {
            return this.total;
        }
        return System.currentTimeMillis() - this.begin + this.total;
    }

    public String toString() {
        long l;
        long l2;
        long l3;
        long l4 = this.total();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.label != null) {
            stringBuffer.append(this.label + ": ");
        }
        if ((l3 = l4 / 3600000L) > 0L) {
            stringBuffer.append(l3 + "h ");
            l4 %= 3600000L;
        }
        if ((l2 = l4 / 60000L) > 0L) {
            stringBuffer.append(l2 + "m ");
            l4 %= 60000L;
        }
        if ((l = l4 / 1000L) > 0L) {
            stringBuffer.append(l + "s ");
            l4 %= 1000L;
        }
        if (l4 > 0L) {
            stringBuffer.append(l4 + "ms");
        }
        return stringBuffer.toString();
    }
}

