/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.client.xmldb;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.dbxml.client.xmldb.CommonConfigurable;
import org.dbxml.client.xmldb.DatabaseImpl;
import org.dbxml.client.xmldb.ManagedObject;
import org.dbxml.client.xmldb.resources.XMLResourceImpl;
import org.dbxml.client.xmldb.services.CollectionManager;
import org.dbxml.client.xmldb.services.DatabaseInstanceManager;
import org.dbxml.client.xmldb.services.XMLObjectService;
import org.dbxml.client.xmldb.services.XPathQueryServiceImpl;
import org.dbxml.client.xmldb.services.XUpdateQueryServiceImpl;
import org.dbxml.core.FaultCodes;
import org.dbxml.core.corba.SymbolDeserializer;
import org.dbxml.core.corba.db.APIException;
import org.dbxml.core.corba.db.Collection;
import org.dbxml.core.corba.db.Database;
import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.xml.SymbolTable;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public class CollectionImpl
extends CommonConfigurable
implements org.xmldb.api.base.Collection,
ManagedObject {
    private static final byte[] EmptyBytes = new byte[0];
    private SymbolDeserializer syms = new SymbolDeserializer();
    protected Collection collection = null;
    protected Database db = null;
    protected DatabaseImpl database = null;
    protected Hashtable services = null;
    protected boolean isOpen = false;
    protected ArrayList objects = null;

    public CollectionImpl(Collection collection, Database database, DatabaseImpl databaseImpl) throws XMLDBException {
        this.collection = collection;
        this.db = database;
        this.database = databaseImpl;
        this.isOpen = true;
        this.services = new Hashtable();
        XPathQueryServiceImpl xPathQueryServiceImpl = new XPathQueryServiceImpl();
        xPathQueryServiceImpl.setCollection(this);
        xPathQueryServiceImpl.setSymbolDeserializer(this.syms);
        this.registerService((Service)xPathQueryServiceImpl);
        XUpdateQueryServiceImpl xUpdateQueryServiceImpl = new XUpdateQueryServiceImpl();
        xUpdateQueryServiceImpl.setCollection(this);
        this.registerService((Service)xUpdateQueryServiceImpl);
        XMLObjectService xMLObjectService = new XMLObjectService();
        xMLObjectService.setCollection(this);
        this.registerService(xMLObjectService);
        try {
            CollectionManager collectionManager = new CollectionManager(collection.getCollectionManager(), database, databaseImpl);
            collectionManager.setCollection(this);
            this.registerService(collectionManager);
            this.services.put("CollectionManagementService" + collectionManager.getVersion(), collectionManager);
            this.registerService(new DatabaseInstanceManager(database.getDatabaseManager(), database, databaseImpl));
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public String getName() throws XMLDBException {
        try {
            return this.collection.getName();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public String getCanonicalName() throws XMLDBException {
        try {
            return this.collection.getCanonicalName();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public Service[] getServices() throws XMLDBException {
        this.checkOpen();
        Enumeration enumeration = this.services.elements();
        Service[] serviceArray = new Service[this.services.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serviceArray[n] = (Service)enumeration.nextElement();
            ++n;
        }
        return serviceArray;
    }

    public Service getService(String string, String string2) throws XMLDBException {
        this.checkOpen();
        Service service = (Service)this.services.get(string + string2);
        return service;
    }

    public org.xmldb.api.base.Collection getParentCollection() throws XMLDBException {
        this.checkOpen();
        try {
            Collection collection = this.collection.getParentCollection();
            if (collection != null) {
                return new CollectionImpl(collection, this.db, this.database);
            }
            return null;
        }
        catch (APIException aPIException) {
            if (aPIException.faultCode == 500) {
                return null;
            }
            throw FaultCodes.createXMLDBException((Exception)((Object)aPIException));
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public int getChildCollectionCount() throws XMLDBException {
        this.checkOpen();
        try {
            String[] stringArray = this.collection.listCollections();
            return stringArray.length;
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public String[] listChildCollections() throws XMLDBException {
        this.checkOpen();
        try {
            return this.collection.listCollections();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public org.xmldb.api.base.Collection getChildCollection(String string) throws XMLDBException {
        this.checkOpen();
        try {
            Collection collection = this.collection.getCollection(string);
            if (collection == null) {
                return null;
            }
            return new CollectionImpl(collection, this.db, this.database);
        }
        catch (APIException aPIException) {
            if (aPIException.faultCode == 200) {
                return null;
            }
            throw FaultCodes.createXMLDBException((Exception)((Object)aPIException));
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public int getResourceCount() throws XMLDBException {
        this.checkOpen();
        try {
            return this.collection.getDocumentCount();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public String[] listResources() throws XMLDBException {
        this.checkOpen();
        try {
            return this.collection.listDocuments();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public Resource getResource(String string) throws XMLDBException {
        this.checkOpen();
        XMLResourceImpl xMLResourceImpl = null;
        try {
            EncodedBuffer encodedBuffer = this.collection.getDocument(string, this.syms.getLastModified());
            if (encodedBuffer.stamp != -1L) {
                SymbolTable symbolTable = this.syms.getSymbols(encodedBuffer);
                xMLResourceImpl = new XMLResourceImpl(string, this, symbolTable, encodedBuffer.buf);
            } else {
                xMLResourceImpl = new XMLResourceImpl(string, this, new String(encodedBuffer.buf));
            }
        }
        catch (APIException aPIException) {
            if (aPIException.faultCode == 201) {
                return null;
            }
            throw FaultCodes.createXMLDBException((Exception)((Object)aPIException));
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
        return xMLResourceImpl;
    }

    public void registerService(Service service) throws XMLDBException {
        this.checkOpen();
        service.setCollection((org.xmldb.api.base.Collection)this);
        this.services.put(service.getName() + service.getVersion(), service);
    }

    public Resource createResource(String string, String string2) throws XMLDBException {
        this.checkOpen();
        if (!string2.equals("XMLResource")) {
            throw new XMLDBException(302);
        }
        if (string == null || string.equals("")) {
            string = this.createId();
        }
        return new XMLResourceImpl(string, this);
    }

    public void removeResource(Resource resource) throws XMLDBException {
        this.checkOpen();
        try {
            this.collection.removeDocument(resource.getId());
        }
        catch (APIException aPIException) {
            if (aPIException.faultCode == 201) {
                throw new XMLDBException(300);
            }
            throw FaultCodes.createXMLDBException((Exception)((Object)aPIException));
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public void storeResource(Resource resource) throws XMLDBException {
        this.checkOpen();
        try {
            EncodedBuffer encodedBuffer = new EncodedBuffer();
            encodedBuffer.sym = EmptyBytes;
            String string = (String)resource.getContent();
            if (string == null) {
                throw new XMLDBException(301);
            }
            encodedBuffer.buf = string.getBytes();
            encodedBuffer.stamp = -1L;
            String string2 = resource.getId();
            if (string2 == null || string2.length() == 0) {
                string2 = this.createId();
            }
            this.collection.insertDocument(string2, encodedBuffer);
        }
        catch (XMLDBException xMLDBException) {
            throw xMLDBException;
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public String createId() throws XMLDBException {
        this.checkOpen();
        try {
            return this.collection.createNewOID();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public void close() throws XMLDBException {
        if (this.isOpen) {
            this.remove();
        }
    }

    public boolean isOpen() throws XMLDBException {
        return this.isOpen;
    }

    public void remove() {
        try {
            ((DatabaseInstanceManager)this.getService("DatabaseInstanceManager", "1.0")).remove();
            ((CollectionManager)this.getService("CollectionManager", "1.0")).remove();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.collection.remove();
        this.isOpen = false;
    }

    public Collection getServerObject() {
        return this.collection;
    }

    void addManagedObject(ManagedObject managedObject) {
        this.objects.add(managedObject);
    }

    protected void checkOpen() throws XMLDBException {
        if (!this.isOpen) {
            throw new XMLDBException(202);
        }
    }
}

