/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.client.xmldb;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import org.dbxml.client.xmldb.CollectionImpl;
import org.dbxml.client.xmldb.CommonConfigurable;
import org.dbxml.core.FaultCodes;
import org.dbxml.core.corba.db.APIException;
import org.dbxml.core.corba.db.DatabaseHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public class DatabaseImpl
extends CommonConfigurable
implements Database {
    protected Hashtable dbs = new Hashtable();
    public static String INSTANCE_NAME = "dbxml";
    public static String SEP = "://";
    public static String CONFORMANCE_LEVEL = "0";
    public static final String DEFAULT_CORBA_NAME = "db";
    public static final String DEFAULT_BOOTSTRAP_URI = "http://localhost:4080/db_bootstrap.ior";
    public static final String CORBA_NAMING_PROP = "dbxml.naming.ior";
    public static final String ORB_CLASS_PROP = "org.omg.CORBA.ORBClass";
    public static final String ORB_SINGLETON_CLASS_PROP = "org.omg.CORBA.ORBSingletonClass";
    protected static String ROOT_CONTEXT = INSTANCE_NAME;

    public String getName() throws XMLDBException {
        return INSTANCE_NAME;
    }

    public Collection getCollection(String string, String string2, String string3) throws XMLDBException {
        String string4;
        String string5;
        if (string == null) {
            throw new XMLDBException(5);
        }
        String string6 = this.getNamingNameFromURI(string);
        if (string6 == null) {
            string6 = DEFAULT_CORBA_NAME;
        }
        if ((string5 = this.getNamingURI(string, string6)) == null) {
            string5 = DEFAULT_BOOTSTRAP_URI;
        }
        if (this.dbs.get(string4 = string5 + " " + string6) == null) {
            this.init(string5, string6);
        }
        String string7 = this.getCollectionFromURI(string);
        CollectionImpl collectionImpl = null;
        try {
            org.dbxml.core.corba.db.Database database = (org.dbxml.core.corba.db.Database)this.dbs.get(string4);
            collectionImpl = new CollectionImpl(database.getCollection(string7), database, this);
        }
        catch (APIException aPIException) {
            if (aPIException.faultCode == 200) {
                return null;
            }
            throw FaultCodes.createXMLDBException((Exception)((java.lang.Object)aPIException));
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
        return collectionImpl;
    }

    public String getConformanceLevel() throws XMLDBException {
        return CONFORMANCE_LEVEL;
    }

    public boolean acceptsURI(String string) throws XMLDBException {
        return string.startsWith(INSTANCE_NAME);
    }

    protected String getCollectionFromURI(String string) throws XMLDBException {
        if (!string.startsWith(INSTANCE_NAME)) {
            throw new XMLDBException(401);
        }
        int n = string.indexOf(47, INSTANCE_NAME.length() + SEP.length());
        n = string.indexOf(47, n + 1);
        String string2 = "/";
        if (n != -1) {
            string2 = string.substring(n, string.length());
        }
        return string2;
    }

    protected String getNamingNameFromURI(String string) throws XMLDBException {
        if (!string.startsWith(INSTANCE_NAME)) {
            throw new XMLDBException(401);
        }
        int n = string.indexOf(47, INSTANCE_NAME.length() + SEP.length());
        int n2 = string.indexOf(47, n + 1);
        String string2 = null;
        string2 = n2 != -1 ? string.substring(n + 1, n2) : string.substring(n + 1, string.length());
        return string2;
    }

    protected String getNamingURI(String string, String string2) throws XMLDBException {
        int n;
        if (!string.startsWith(INSTANCE_NAME)) {
            throw new XMLDBException(401);
        }
        String string3 = null;
        int n2 = string.indexOf("//", INSTANCE_NAME.length());
        if (n2 != (n = string.indexOf(47, n2 + 2)) - 2) {
            string3 = string.substring(n2 + 2, n);
            string3 = "http://" + string3 + "/" + string2 + ".ior";
        }
        return string3;
    }

    protected void init(String string, String string2) throws XMLDBException {
        Properties properties = this.getOrbConfig();
        try {
            ORB oRB = ORB.init((String[])new String[0], (Properties)properties);
            org.dbxml.core.corba.db.Database database = null;
            String string3 = (String)this.config.get(CORBA_NAMING_PROP);
            if (string3 != null) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>(5, 0.75f);
                hashtable.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
                hashtable.put("java.naming.provider.url", string3);
                hashtable.put("java.naming.corba.orb", (String)oRB);
                InitialContext initialContext = new InitialContext(hashtable);
                database = DatabaseHelper.narrow((Object)initialContext.lookup(ROOT_CONTEXT + "/" + string2));
            } else {
                URL uRL = new URL(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String string4 = bufferedReader.readLine();
                bufferedReader.close();
                database = DatabaseHelper.narrow(oRB.string_to_object(string4));
            }
            this.dbs.put(string + " " + string2, database);
        }
        catch (Exception exception) {
            throw new XMLDBException(1, 1, "A connection to the Database instance '" + string2 + "' could not be created. Error: " + exception.getMessage());
        }
    }

    protected Properties getOrbConfig() {
        String string;
        Properties properties = new Properties();
        String string2 = (String)this.config.get(ORB_CLASS_PROP);
        if (string2 != null) {
            ((Hashtable)properties).put(ORB_CLASS_PROP, string2);
        }
        if ((string = (String)this.config.get(ORB_SINGLETON_CLASS_PROP)) != null) {
            ((Hashtable)properties).put(ORB_SINGLETON_CLASS_PROP, string);
        }
        return properties;
    }
}

