/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.client.xmldb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dbxml.client.xmldb.CollectionImpl;
import org.dbxml.client.xmldb.ResourceIteratorImpl;
import org.dbxml.client.xmldb.resources.XMLResourceImpl;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.TextWriter;
import org.dbxml.xml.dom.DOMCompressor;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class ResourceSetImpl
implements ResourceSet {
    public static final String RESOURCE_SET_NS = "http://www.xmldb.org/xapi/ResourceSet";
    protected List resources = null;
    protected Collection collection = null;
    private SymbolTable symbols = null;
    private byte[] bytes = null;

    public ResourceSetImpl(Collection collection, Document document) throws XMLDBException {
        this.collection = collection;
        if (document != null) {
            this.initResources(document);
        } else {
            this.resources = Collections.synchronizedList(new ArrayList());
        }
    }

    public ResourceSetImpl(Collection collection, SymbolTable symbolTable, byte[] byArray) throws XMLDBException {
        this.collection = collection;
        this.symbols = symbolTable;
        this.bytes = byArray;
        this.initResources(new DocumentImpl(byArray, symbolTable, null));
    }

    protected void initResources(Document document) throws XMLDBException {
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        this.resources = Collections.synchronizedList(new ArrayList(nodeList.getLength()));
        for (int i = 0; i < nodeList.getLength(); ++i) {
            try {
                XMLResourceImpl xMLResourceImpl;
                Node node = nodeList.item(i);
                String string = ((Element)node).getAttributeNS("http://www.dbxml.org/Query", "key");
                if (this.bytes != null) {
                    DocumentImpl documentImpl = new DocumentImpl();
                    documentImpl.setSymbols(this.symbols);
                    documentImpl.importNode(node, true);
                    documentImpl.appendChild(node);
                    byte[] byArray = DOMCompressor.Compress(documentImpl, this.symbols);
                    xMLResourceImpl = new XMLResourceImpl(null, string, this.collection, this.symbols, byArray);
                } else {
                    xMLResourceImpl = new XMLResourceImpl(null, string, this.collection, TextWriter.toString(node));
                }
                this.resources.add(xMLResourceImpl);
                continue;
            }
            catch (Exception exception) {
                throw new XMLDBException(0);
            }
        }
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new ResourceIteratorImpl(this.resources);
    }

    public Resource getResource(long l) throws XMLDBException {
        return (XMLResource)this.resources.get((int)l);
    }

    public long getSize() throws XMLDBException {
        return this.resources.size();
    }

    public void addResource(Resource resource) throws XMLDBException {
        this.resources.add(resource);
    }

    public void clear() throws XMLDBException {
        this.resources.clear();
    }

    public void removeResource(long l) throws XMLDBException {
        this.resources.remove((int)l);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        XMLResource xMLResource;
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElementNS(RESOURCE_SET_NS, "xapi:resourceSet");
        element.setAttributeNS(RESOURCE_SET_NS, "xapi:collectionURI", "xmldb:dbxml://" + ((CollectionImpl)this.collection).getCanonicalName());
        element.setAttribute("xmlns:xapi", RESOURCE_SET_NS);
        documentImpl.appendChild(element);
        int n = 0;
        while (n < this.resources.size()) {
            xMLResource = (XMLResource)this.resources.get(n);
            Element element2 = documentImpl.createElementNS(RESOURCE_SET_NS, "xapi:resource");
            element2.setAttributeNS(RESOURCE_SET_NS, "xapi:documentID", xMLResource.getDocumentId());
            element2.appendChild(documentImpl.importNode(((Document)xMLResource.getContentAsDOM()).getDocumentElement(), true));
            element.appendChild(element2);
            ++n;
        }
        xMLResource = new XMLResourceImpl(null, null, this.collection, TextWriter.toString(documentImpl));
        return xMLResource;
    }
}

