/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.client.xmldb.resources;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dbxml.core.FaultCodes;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.TextWriter;
import org.dbxml.xml.dom.DOMParser;
import org.dbxml.xml.dom.DocumentImpl;
import org.dbxml.xml.sax.SAXEventGenerator;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.sdk.modules.SetContentHandler;

public class XMLResourceImpl
implements XMLResource {
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    protected String id = null;
    protected String documentId = null;
    protected Collection collection = null;
    protected String content = null;
    private SymbolTable symbols = null;
    private byte[] bytes = null;

    public XMLResourceImpl(String string, Collection collection) {
        this(string, string, collection, null);
    }

    public XMLResourceImpl(String string, String string2, Collection collection) {
        this(string, string2, collection, null);
    }

    public XMLResourceImpl(String string, Collection collection, String string2) {
        this(string, string, collection, string2);
    }

    public XMLResourceImpl(String string, String string2, Collection collection, String string3) {
        this.collection = collection;
        this.id = string;
        this.documentId = string2;
        this.content = string3;
    }

    public XMLResourceImpl(String string, String string2, Collection collection, SymbolTable symbolTable, byte[] byArray) {
        this.collection = collection;
        this.id = string;
        this.documentId = string2;
        this.symbols = symbolTable;
        this.bytes = byArray;
    }

    public XMLResourceImpl(String string, Collection collection, SymbolTable symbolTable, byte[] byArray) {
        this(string, string, collection, symbolTable, byArray);
    }

    public String getDocumentId() throws XMLDBException {
        return this.documentId;
    }

    public void setContent(Object object) throws XMLDBException {
        if (object == null) {
            throw new XMLDBException(301);
        }
        if (!(object instanceof String)) {
            throw new XMLDBException(3);
        }
        this.content = (String)object;
        this.bytes = null;
    }

    public void setContentAsDOM(Node node) throws XMLDBException {
        if (node == null) {
            throw new XMLDBException(301);
        }
        this.content = new TextWriter(node).toString();
        this.bytes = null;
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        return new SetContentHandler((XMLResource)this);
    }

    public Collection getParentCollection() throws XMLDBException {
        return this.collection;
    }

    public String getResourceType() throws XMLDBException {
        return "XMLResource";
    }

    public String getId() throws XMLDBException {
        return this.id;
    }

    public Object getContent() throws XMLDBException {
        if (this.bytes != null) {
            DocumentImpl documentImpl = new DocumentImpl(this.bytes, this.symbols, null);
            return TextWriter.toString(documentImpl);
        }
        return this.content;
    }

    public Node getContentAsDOM() throws XMLDBException {
        try {
            if (this.bytes != null) {
                return new DocumentImpl(this.bytes, this.symbols, null);
            }
            return DOMParser.toDocument(this.content);
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public void getContentAsSAX(ContentHandler contentHandler) throws XMLDBException {
        try {
            if (this.bytes != null) {
                SAXEventGenerator sAXEventGenerator = new SAXEventGenerator(this.symbols, this.bytes);
                sAXEventGenerator.setContentHandler(contentHandler);
                if (contentHandler instanceof ErrorHandler) {
                    sAXEventGenerator.setErrorHandler((ErrorHandler)((Object)contentHandler));
                }
                sAXEventGenerator.start();
            } else {
                SAXParser sAXParser = saxFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                xMLReader.setContentHandler(contentHandler);
                if (contentHandler instanceof ErrorHandler) {
                    xMLReader.setErrorHandler((ErrorHandler)((Object)contentHandler));
                }
                if (this.content != null) {
                    xMLReader.parse(new InputSource(new StringReader(this.content)));
                }
            }
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }
}

