/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.client.xmldb.services;

import org.dbxml.client.xmldb.CollectionImpl;
import org.dbxml.client.xmldb.CommonConfigurable;
import org.dbxml.client.xmldb.DatabaseImpl;
import org.dbxml.client.xmldb.ManagedObject;
import org.dbxml.core.FaultCodes;
import org.dbxml.core.corba.EncodedBufferConverter;
import org.dbxml.core.corba.db.Database;
import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class CollectionManager
extends CommonConfigurable
implements ManagedObject,
Service,
CollectionManagementService {
    protected org.dbxml.core.corba.db.CollectionManager manager = null;
    protected Database db = null;
    protected Collection collection = null;
    protected DatabaseImpl database = null;

    public CollectionManager(org.dbxml.core.corba.db.CollectionManager collectionManager, Database database, DatabaseImpl databaseImpl) {
        this.manager = collectionManager;
        this.db = database;
        this.database = databaseImpl;
    }

    public String getName() {
        return "CollectionManager";
    }

    public String getVersion() {
        return "1.0";
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public String getCollectionName() throws XMLDBException {
        try {
            return this.manager.getName();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public String getCanonicalName() throws XMLDBException {
        try {
            return this.manager.getCanonicalName();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public Collection createCollection(String string, Document document) throws XMLDBException {
        try {
            EncodedBuffer encodedBuffer = EncodedBufferConverter.convertFromDocument(document);
            CollectionImpl collectionImpl = new CollectionImpl(this.manager.createCollection(string, encodedBuffer), this.db, this.database);
            return collectionImpl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public void dropCollection(String string) throws XMLDBException {
        try {
            this.manager.dropCollection(string);
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public String[] listIndexers() throws XMLDBException {
        try {
            return this.manager.listIndexers();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public void createIndexer(Document document) throws XMLDBException {
        EncodedBuffer encodedBuffer = EncodedBufferConverter.convertFromDocument(document);
        try {
            this.manager.createIndexer(encodedBuffer);
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public void dropIndexer(String string) throws XMLDBException {
        try {
            this.manager.dropIndexer(string);
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public String[] listXMLObjects() throws XMLDBException {
        try {
            return this.manager.listXMLObjects();
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public void createXMLObject(Document document) throws XMLDBException {
        EncodedBuffer encodedBuffer = EncodedBufferConverter.convertFromDocument(document);
        try {
            this.manager.createXMLObject(encodedBuffer);
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public void dropXMLObject(String string) throws XMLDBException {
        try {
            this.manager.dropXMLObject(string);
        }
        catch (Exception exception) {
            throw FaultCodes.createXMLDBException(exception);
        }
    }

    public Collection createCollection(String string) throws XMLDBException {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("collection");
        element.setAttribute("compressed", "true");
        element.setAttribute("name", string);
        documentImpl.appendChild(element);
        Element element2 = documentImpl.createElement("filer");
        element2.setAttribute("class", "org.dbxml.core.filer.BTreeFiler");
        element2.setAttribute("gzip", "true");
        element.appendChild(element2);
        return this.createCollection(string, documentImpl);
    }

    public void removeCollection(String string) throws XMLDBException {
        this.dropCollection(string);
    }

    protected org.dbxml.core.corba.db.CollectionManager getServerObject() {
        return this.manager;
    }

    public void remove() {
        this.manager.remove();
    }
}

