/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.client.xmldb.services;

import java.util.Iterator;
import org.dbxml.client.xmldb.CollectionImpl;
import org.dbxml.client.xmldb.CommonConfigurable;
import org.dbxml.client.xmldb.ResourceSetImpl;
import org.dbxml.client.xmldb.resources.XMLResourceImpl;
import org.dbxml.core.corba.EncodedBufferConverter;
import org.dbxml.core.corba.SymbolDeserializer;
import org.dbxml.core.corba.db.Collection;
import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.core.corba.db.NamedVal;
import org.dbxml.xml.NamespaceMap;
import org.dbxml.xml.SymbolTable;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XPathQueryServiceImpl
extends CommonConfigurable
implements XPathQueryService {
    private SymbolDeserializer syms;
    private NamespaceMap nsMap = new NamespaceMap();
    protected org.xmldb.api.base.Collection collection = null;

    public String getName() throws XMLDBException {
        return "XPathQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(org.xmldb.api.base.Collection collection) throws XMLDBException {
        this.collection = collection;
    }

    public void setSymbolDeserializer(SymbolDeserializer symbolDeserializer) {
        this.syms = symbolDeserializer;
    }

    public void setDefaultNamespace(String string) throws XMLDBException {
        if (string != null) {
            this.nsMap.setDefaultNamespace(string);
        } else {
            this.nsMap.removeDefaultNamespace();
        }
    }

    public void removeDefaultNamespace() {
        this.nsMap.removeDefaultNamespace();
    }

    public void setNamespace(String string, String string2) throws XMLDBException {
        if (string == null || string.equals("")) {
            this.setDefaultNamespace(string2);
        } else if (string2 != null) {
            this.nsMap.setNamespace(string, string2);
        }
    }

    public void removeNamespace(String string) {
        if (string == null || string.equals("")) {
            this.removeDefaultNamespace();
        }
        this.nsMap.removeNamespace(string);
    }

    public String getDefaultNamespace() {
        return this.nsMap.getDefaultNamespaceURI();
    }

    public String getNamespace(String string) {
        if (string == null || string.equals("")) {
            return this.nsMap.getDefaultNamespaceURI();
        }
        return this.nsMap.getNamespaceURI(string);
    }

    public void clearNamespaces() {
        this.nsMap.clear();
    }

    private NamedVal[] getNamespaces() {
        NamedVal[] namedValArray = new NamedVal[this.nsMap.size()];
        Iterator iterator = this.nsMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.nsMap.getNamespaceURI(string);
            namedValArray[n++] = new NamedVal(string, string2);
        }
        return namedValArray;
    }

    public ResourceSet query(String string) throws XMLDBException {
        Collection collection = ((CollectionImpl)this.collection).getServerObject();
        ResourceSetImpl resourceSetImpl = null;
        try {
            EncodedBuffer encodedBuffer = collection.queryCollection("XPath", string, this.getNamespaces(), this.syms.getLastModified());
            if (encodedBuffer.stamp != -1L) {
                SymbolTable symbolTable = this.syms.getSymbols(encodedBuffer);
                resourceSetImpl = new ResourceSetImpl(this.collection, symbolTable, encodedBuffer.buf);
            } else {
                resourceSetImpl = new ResourceSetImpl(this.collection, EncodedBufferConverter.convertToDocument(encodedBuffer));
            }
        }
        catch (Exception exception) {
            resourceSetImpl = new ResourceSetImpl(this.collection, null);
        }
        return resourceSetImpl;
    }

    public ResourceSet queryResource(String string, String string2) throws XMLDBException {
        Collection collection = ((CollectionImpl)this.collection).getServerObject();
        ResourceSetImpl resourceSetImpl = null;
        try {
            EncodedBuffer encodedBuffer = collection.queryDocument("XPath", string2, this.getNamespaces(), string, this.syms.getLastModified());
            if (encodedBuffer.stamp != -1L) {
                SymbolTable symbolTable = this.syms.getSymbols(encodedBuffer);
                resourceSetImpl = new ResourceSetImpl(this.collection, symbolTable, encodedBuffer.buf);
            } else {
                resourceSetImpl = new ResourceSetImpl(this.collection, EncodedBufferConverter.convertToDocument(encodedBuffer));
            }
        }
        catch (Exception exception) {
            resourceSetImpl = new ResourceSetImpl(this.collection, null);
        }
        return resourceSetImpl;
    }

    public XMLResource queryResult(String string) throws XMLDBException {
        Collection collection = ((CollectionImpl)this.collection).getServerObject();
        XMLResourceImpl xMLResourceImpl = null;
        try {
            EncodedBuffer encodedBuffer = collection.queryCollection("XPath", string, this.getNamespaces(), this.syms.getLastModified());
            if (encodedBuffer.stamp != -1L) {
                SymbolTable symbolTable = this.syms.getSymbols(encodedBuffer);
                xMLResourceImpl = new XMLResourceImpl("", this.collection, symbolTable, encodedBuffer.buf);
            } else {
                xMLResourceImpl = new XMLResourceImpl("", this.collection, new String(encodedBuffer.buf));
            }
        }
        catch (Exception exception) {
            xMLResourceImpl = null;
        }
        return xMLResourceImpl;
    }
}

