/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import org.dbxml.Debug;
import org.dbxml.core.CollectionManager;
import org.dbxml.core.Container;
import org.dbxml.core.DBException;
import org.dbxml.core.DBObject;
import org.dbxml.core.Database;
import org.dbxml.core.DocumentCache;
import org.dbxml.core.SystemCollection;
import org.dbxml.core.data.DocumentSet;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.NodeSet;
import org.dbxml.core.data.Record;
import org.dbxml.core.data.RecordSet;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.Filer;
import org.dbxml.core.indexer.IndexManager;
import org.dbxml.core.indexer.Indexer;
import org.dbxml.core.objects.Variant;
import org.dbxml.core.objects.XMLObject;
import org.dbxml.core.objects.XMLObjectManager;
import org.dbxml.core.query.QueryEngine;
import org.dbxml.server.Configurable;
import org.dbxml.server.Configuration;
import org.dbxml.server.Named;
import org.dbxml.server.dbXMLException;
import org.dbxml.xml.NamespaceMap;
import org.dbxml.xml.NodeSource;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.XMLSerializable;
import org.dbxml.xml.dom.DBDocument;
import org.dbxml.xml.dom.DOMCompressor;
import org.dbxml.xml.dom.DOMParser;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class Collection
extends CollectionManager
implements Named,
DBObject,
Configurable {
    private static final String NAME = "name";
    private static final String FILER = "filer";
    private static final String CLASS = "class";
    private static final String LOCATION = "location";
    private static final String INDEXES = "indexes";
    private static final String COMPRESSED = "compressed";
    private static final String CACHE = "cache";
    private static final String XMLOBJECTS = "xmlobjects";
    private static final String DOCUMENTS = "documents";
    private static final String SYMBOLS = "symbols";
    private static final String CLASSNAME = "dbxml-class";
    private static final String[] EmptyStrings = new String[0];
    private static int host_id;
    private Collection parent = null;
    private int collection_id = 0;
    private long document_id = System.currentTimeMillis();
    private Object oidMutex = new Object();
    private String oidTemplate = null;
    protected String name;
    private String canonicalName;
    private File collectionRoot;
    private Filer filer = null;
    private boolean compressed = false;
    private SymbolTable symbols = null;
    private boolean internalSymbols = false;
    private IndexManager indexManager;
    private XMLObjectManager xmlObjects;
    private DocumentCache documentCache;

    protected Collection() {
    }

    public Collection(Collection collection) {
        this();
        this.parent = collection;
    }

    public void setConfig(Configuration configuration) throws dbXMLException {
        Configuration configuration2;
        Configuration configuration3;
        this.config = configuration;
        this.name = configuration.getAttribute(NAME);
        this.compressed = configuration.getBooleanAttribute(COMPRESSED, true);
        if (this.parent != null) {
            this.setCanonicalName(this.parent.getCanonicalName() + '/' + this.name);
            this.setCollectionRoot(new File(this.parent.getCollectionRoot(), this.name));
        }
        if (configuration.getBooleanAttribute(CACHE, true)) {
            this.documentCache = this.getDatabase().getDocumentCache();
        }
        if ((configuration3 = configuration.getChild(FILER)) != null) {
            configuration2 = configuration.getChild(SYMBOLS);
            boolean bl = this.internalSymbols = configuration2 != null;
            if (this.internalSymbols) {
                try {
                    this.symbols = new SymbolTable(configuration2.getElement());
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            } else {
                try {
                    this.symbols = this.getSystemCollection().loadSymbols(this);
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            }
            String string = configuration3.getAttribute(CLASS);
            try {
                this.filer = (Filer)Class.forName(string).newInstance();
                this.filer.setCollection(this);
                this.filer.setConfig(configuration3);
                if (!this.filer.exists()) {
                    this.filer.create();
                }
                this.filer.open();
            }
            catch (Exception exception) {
                Debug.println((Object)("Filer '" + string + "' not available"));
            }
            try {
                this.indexManager = new IndexManager(this);
                Configuration configuration4 = configuration.getChild(INDEXES, true);
                this.indexManager.setConfig(configuration4);
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }
        this.xmlObjects = new XMLObjectManager(this);
        try {
            configuration2 = configuration.getChild(XMLOBJECTS, true);
            this.xmlObjects.setConfig(configuration2);
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        super.setConfig(configuration);
    }

    public final String getName() {
        return this.name;
    }

    public final File getCollectionRoot() {
        return this.collectionRoot;
    }

    protected final void setCollectionRoot(File file) {
        this.collectionRoot = file;
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public final Collection getParentCollection() throws DBException {
        return this.parent;
    }

    public Database getDatabase() {
        return this.parent.getDatabase();
    }

    public SystemCollection getSystemCollection() throws DBException {
        return this.getDatabase().getSystemCollection();
    }

    public QueryEngine getQueryEngine() throws DBException {
        return this.getDatabase().getQueryEngine();
    }

    private void checkFiler(int n) throws DBException {
        if (this.filer == null) {
            throw new DBException(n, "This Collection '" + this.name + "' cannot store Documents");
        }
    }

    public final Indexer getIndexer(String string) throws DBException {
        this.checkFiler(242);
        return this.indexManager.get(string);
    }

    public final String[] listIndexers() throws DBException {
        this.checkFiler(242);
        return this.indexManager.list();
    }

    public final boolean dropIndexer(Indexer indexer) throws DBException {
        this.checkFiler(242);
        if (indexer == null) {
            throw new DBException(301, "Index Value Null");
        }
        return this.indexManager.drop(indexer.getName());
    }

    public final Indexer createIndexer(Configuration configuration) throws DBException {
        this.checkFiler(242);
        return this.indexManager.create(configuration);
    }

    public final Filer getFiler() {
        return this.filer;
    }

    public final IndexManager getIndexManager() throws DBException {
        this.checkFiler(242);
        return this.indexManager;
    }

    public final XMLObjectManager getXMLObjectManager() throws DBException {
        return this.xmlObjects;
    }

    public final XMLObject getXMLObject(String string) throws DBException {
        return this.xmlObjects.get(string);
    }

    public String[] listXMLObjects() throws DBException {
        return this.xmlObjects.list();
    }

    public final boolean dropXMLObject(XMLObject xMLObject) throws DBException {
        if (xMLObject == null) {
            throw new DBException(100, "Object Value Null");
        }
        return this.xmlObjects.drop(xMLObject.getName());
    }

    public final XMLObject createXMLObject(Configuration configuration) throws DBException {
        return this.xmlObjects.create(configuration);
    }

    public final SymbolTable getSymbols() throws DBException {
        return this.symbols;
    }

    private Document parseDocument(Key key, String string) throws DBException {
        Document document = null;
        try {
            document = DOMParser.toDocument(string);
            byte[] byArray = DOMCompressor.Compress(document, this.symbols);
            document = new DocumentImpl(byArray, this.symbols, new NodeSource(this, key));
            if (this.documentCache != null) {
                this.documentCache.putDocument(this, key, byArray);
            }
        }
        catch (Exception exception) {
            throw new DBException(243, "Unable to parse Document");
        }
        return document;
    }

    public final String getCanonicalName() {
        return this.canonicalName;
    }

    protected final void setCanonicalName(String string) {
        this.canonicalName = string;
        this.collection_id = Math.abs(string.hashCode());
        StringBuffer stringBuffer = new StringBuffer("00000000000000000000000000000000");
        String string2 = Integer.toString(host_id, 16);
        String string3 = Integer.toString(this.collection_id, 16);
        stringBuffer.insert(8 - string2.length(), string2);
        stringBuffer.insert(16 - string3.length(), string3);
        stringBuffer.setLength(32);
        this.oidTemplate = stringBuffer.toString();
    }

    public final String getCanonicalDocumentName(Key key) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.canonicalName);
        stringBuffer.append('/');
        stringBuffer.append(key.toString());
        return stringBuffer.toString();
    }

    public final boolean open() throws DBException {
        return true;
    }

    public boolean isOpened() throws DBException {
        return true;
    }

    public boolean exists() throws DBException {
        return true;
    }

    public boolean close() throws DBException {
        return true;
    }

    public boolean create() throws DBException {
        return true;
    }

    public boolean drop() throws DBException {
        if (this == this.getDatabase()) {
            throw new DBException(570, "You Cannot Drop The Database");
        }
        String[] stringArray = this.listCollections();
        int n = 0;
        while (n < stringArray.length) {
            this.dropCollection(this.getCollection(stringArray[n]));
            ++n;
        }
        String[] stringArray2 = this.listXMLObjects();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.dropXMLObject(this.getXMLObject(stringArray2[n2]));
            ++n2;
        }
        if (this.filer != null) {
            String[] stringArray3 = this.indexManager.list();
            int n3 = 0;
            while (n3 < stringArray3.length) {
                this.dropIndexer(this.getIndexer(stringArray3[n3]));
                ++n3;
            }
            this.filer.drop();
        }
        this.getCollectionRoot().delete();
        return true;
    }

    public final Key createNewOID() {
        long l = System.currentTimeMillis();
        Object object = this.oidMutex;
        synchronized (object) {
            if (l <= this.document_id) {
                l = this.document_id + 1L;
            }
            this.document_id = l;
        }
        StringBuffer stringBuffer = new StringBuffer(this.oidTemplate);
        String string = Long.toString(this.document_id, 16);
        stringBuffer.insert(32 - string.length(), string);
        stringBuffer.setLength(32);
        return new Key(stringBuffer.toString());
    }

    protected final Key createNewKey(Object object) {
        if (object == null) {
            return this.createNewOID();
        }
        if (object instanceof Key) {
            return (Key)object;
        }
        return new Key(object.toString());
    }

    public final void flushSymbolTable() throws DBException {
        if (this.symbols.isDirty() && !this.internalSymbols) {
            this.getSystemCollection().saveSymbols(this, this.symbols);
        }
    }

    private void putDocument(Key key, Document document, boolean bl) throws DBException {
        Object object;
        Object object2;
        this.checkFiler(242);
        if (document instanceof DBDocument && (object2 = (DBDocument)document).getSource() == null) {
            object2.setSource(new NodeSource(this, key));
        }
        object2 = null;
        if (this.compressed) {
            try {
                object = DOMCompressor.Compress(document, this.symbols);
                object2 = new Value((byte[])object);
                document = new DocumentImpl((byte[])object, this.symbols, new NodeSource(this, key));
            }
            catch (Exception exception) {
                throw new DBException(244, "Error storing Document '" + key + "'");
            }
        } else {
            object2 = new Value(new Variant(document).toString());
        }
        this.flushSymbolTable();
        object = this.getDocument(key);
        if (object != null) {
            this.indexManager.removeDocument(key, (Document)object);
        }
        this.indexManager.addDocument(key, document);
        this.filer.writeRecord(key, (Value)object2);
        if (this.documentCache != null) {
            if (this.compressed) {
                this.documentCache.putDocument(this, key, ((Value)object2).getData());
            } else {
                this.documentCache.putDocument(this, key, document);
            }
        }
    }

    public final Key insertDocument(Document document) throws DBException {
        Key key = this.createNewOID();
        this.putDocument(key, document, true);
        return key;
    }

    public final void insertDocument(Object object, Document document) throws DBException {
        this.putDocument(this.createNewKey(object), document, true);
    }

    public final void setDocument(Object object, Document document) throws DBException {
        this.putDocument(this.createNewKey(object), document, false);
    }

    public final void remove(Object object) throws DBException {
        this.checkFiler(242);
        Key key = this.createNewKey(object);
        Document document = this.getDocument(key);
        if (document != null) {
            this.indexManager.removeDocument(key, document);
        }
        if (this.documentCache != null) {
            this.documentCache.removeDocument(this, key);
        }
        if (!this.filer.deleteRecord(key)) {
            throw new DBException(201, "Document Does Not Exist");
        }
    }

    public final Document getDocument(Object object) throws DBException {
        this.getDatabase().getSecurityManager().checkAccess(this.getCanonicalName() + "/", 1);
        this.checkFiler(242);
        Key key = this.createNewKey(object);
        Document document = null;
        if (this.documentCache != null) {
            document = this.documentCache.getDocument(this, key);
        }
        if (document == null) {
            Record record = this.filer.readRecord(key);
            if (record == null) {
                return null;
            }
            Value value = record.getValue();
            if (this.compressed) {
                document = new DocumentImpl(value.getData(), this.symbols, new NodeSource(this, key));
                if (this.documentCache != null) {
                    this.documentCache.putDocument(this, key, value.getData());
                }
            } else {
                document = this.parseDocument(key, value.toString());
            }
            this.flushSymbolTable();
        }
        return document;
    }

    public final Container getContainer(Object object) throws DBException {
        Key key = this.createNewKey(object);
        Document document = this.getDocument(key);
        return document != null ? new ColContainer(key, document) : null;
    }

    public final XMLSerializable getObject(Object object) throws DBException {
        String string = null;
        Document document = this.getDocument(object);
        if (document != null) {
            Object object2;
            NodeList nodeList = document.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                object2 = nodeList.item(n2);
                if (object2.getNodeType() == 7 && object2.getNodeName().equals(CLASSNAME)) {
                    string = object2.getNodeValue().trim();
                    break;
                }
                ++n2;
            }
            if (string != null) {
                try {
                    object2 = (XMLSerializable)Class.forName(string).newInstance();
                    object2.streamFromXML(document.getDocumentElement());
                    return object2;
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            }
        }
        return null;
    }

    private void putObject(Key key, XMLSerializable xMLSerializable, boolean bl) throws DBException {
        DocumentImpl documentImpl = new DocumentImpl();
        ProcessingInstruction processingInstruction = documentImpl.createProcessingInstruction(CLASSNAME, xMLSerializable.getClass().getName());
        documentImpl.appendChild(processingInstruction);
        Element element = xMLSerializable.streamToXML(documentImpl);
        documentImpl.appendChild(element);
        this.putDocument(key, documentImpl, bl);
    }

    public final void setObject(Object object, XMLSerializable xMLSerializable) throws DBException {
        this.putObject(this.createNewKey(object), xMLSerializable, false);
    }

    public final Key insertObject(XMLSerializable xMLSerializable) throws DBException {
        Key key = this.createNewOID();
        this.putObject(key, xMLSerializable, true);
        return key;
    }

    public final void insertObject(String string, XMLSerializable xMLSerializable) throws DBException {
        this.putObject(this.createNewKey(string), xMLSerializable, true);
    }

    public final NodeSet queryCollection(String string, String string2, NamespaceMap namespaceMap) throws DBException {
        this.checkFiler(671);
        return this.getQueryEngine().query(this, string, string2, namespaceMap, null);
    }

    public final NodeSet queryDocument(String string, String string2, NamespaceMap namespaceMap, Object object) throws DBException {
        this.checkFiler(671);
        Key[] keyArray = null;
        keyArray = object instanceof Key[] ? (Key[])object : new Key[]{this.createNewKey(object)};
        return this.getQueryEngine().query(this, string, string2, namespaceMap, keyArray);
    }

    public final DocumentSet getDocumentSet() throws DBException {
        this.checkFiler(242);
        return new ColDocumentSet(this.filer.getRecordSet());
    }

    public final String[] listDocuments() throws DBException {
        this.checkFiler(242);
        RecordSet recordSet = this.filer.getRecordSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (recordSet.hasMoreRecords()) {
            Key key = recordSet.getNextKey();
            arrayList.add(key.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    public final long getDocumentCount() throws DBException {
        this.checkFiler(242);
        return this.filer.getRecordCount();
    }

    static {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            host_id = 0;
            host_id += byArray[0];
            host_id += byArray[1] << 8;
            host_id += byArray[2] << 16;
            host_id += byArray[3] << 24;
            host_id = Math.abs(host_id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ColContainer
    implements Container {
        private Key key;
        private Document document;

        public ColContainer(Key key, Document document) {
            this.key = key;
            this.document = document;
        }

        public Collection getCollection() {
            return Collection.this;
        }

        public Key getKey() {
            return this.key;
        }

        public String getCanonicalName() throws DBException {
            return Collection.this.getCanonicalDocumentName(this.key);
        }

        public Document getDocument() {
            return this.document;
        }

        public Document rollback() throws DBException {
            this.document = Collection.this.getDocument(this.key);
            return this.document;
        }

        public void commit(Document document) throws DBException {
            this.document = document;
            this.commit();
        }

        public void commit() throws DBException {
            Collection.this.putDocument(this.key, this.document, false);
        }

        public void remove() throws DBException {
            Collection.this.remove(this.key);
        }
    }

    private class ColDocumentSet
    implements DocumentSet {
        private RecordSet set;

        public ColDocumentSet(RecordSet recordSet) {
            this.set = recordSet;
        }

        public boolean hasMoreDocuments() throws DBException {
            return this.set.hasMoreRecords();
        }

        public Container getNextContainer() throws DBException {
            if (this.set.hasMoreRecords()) {
                Record record = this.set.getNextRecord();
                Key key = record.getKey();
                Value value = record.getValue();
                if (value.getData() != null) {
                    try {
                        if (Collection.this.compressed) {
                            DocumentImpl documentImpl = new DocumentImpl(value.getData(), Collection.this.symbols, new NodeSource(Collection.this, key));
                            return new ColContainer(key, documentImpl);
                        }
                        return new ColContainer(key, DOMParser.toDocument(value));
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace((Throwable)exception);
                    }
                }
            }
            return null;
        }

        public Document getNextDocument() throws DBException {
            Container container = this.getNextContainer();
            if (container != null) {
                return container.getDocument();
            }
            return null;
        }
    }
}

