/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.Database;
import org.dbxml.server.Configurable;
import org.dbxml.server.Configuration;
import org.dbxml.server.ConfigurationCallback;
import org.dbxml.server.Disposable;
import org.dbxml.server.dbXMLException;

public class CollectionManager
implements Configurable,
Disposable {
    private static final String COLLECTIONS = "collections";
    private static final String COLLECTION = "collection";
    private static final String NAME = "name";
    private static final String[] EmptyStrings = new String[0];
    protected Map collections = new HashMap();
    protected Configuration config = null;

    protected CollectionManager() {
    }

    public void setConfig(Configuration configuration) throws dbXMLException {
        this.config = configuration;
        Configuration configuration2 = configuration.getChild(COLLECTIONS);
        if (configuration2 != null) {
            configuration2.processChildren(COLLECTION, new ConfigurationCallback(){

                public void process(Configuration configuration) throws dbXMLException {
                    Collection collection = new Collection((Collection)CollectionManager.this);
                    collection.setConfig(configuration);
                    CollectionManager.this.collections.put(collection.getName(), collection);
                }
            });
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Collection getCollection(String string) throws DBException {
        if (string.indexOf("/") != -1) {
            CollectionManager collectionManager = this;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (collectionManager != null && stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                collectionManager = (CollectionManager)collectionManager.collections.get(string);
            }
            return (Collection)collectionManager;
        }
        return (Collection)this.collections.get(string);
    }

    public final String[] listCollections() throws DBException {
        return this.collections.keySet().toArray(EmptyStrings);
    }

    public final boolean dropCollection(Collection collection) throws DBException {
        if (collection == null) {
            throw new DBException(200, "Collection Value Null");
        }
        Collection collection2 = collection.getParentCollection();
        if (collection2 == null) {
            throw new DBException(570, "You Cannot Drop The Database");
        }
        if (collection2 != this) {
            return collection2.dropCollection(collection);
        }
        String string = collection.getCanonicalName();
        final String string2 = collection.getName();
        boolean bl = collection.drop();
        if (bl) {
            this.collections.remove(string2);
            Configuration configuration = this.config.getChild(COLLECTIONS);
            configuration.processChildren(COLLECTION, new ConfigurationCallback(){

                public void process(Configuration configuration) {
                    try {
                        if (configuration.getAttribute(CollectionManager.NAME).equals(string2)) {
                            configuration.delete();
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace((Throwable)exception);
                    }
                }
            });
        }
        return bl;
    }

    public final Collection createCollection(String string, Configuration configuration) throws DBException {
        if (string.indexOf("/") != -1) {
            CollectionManager collectionManager = this;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (collectionManager != null && stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (string.length() == 0) continue;
                if (stringTokenizer.hasMoreTokens()) {
                    collectionManager = (CollectionManager)collectionManager.collections.get(string);
                    continue;
                }
                return collectionManager.createCollection(string, configuration);
            }
            throw new DBException(200, "Parent Collection '" + string + "' doesn't exist");
        }
        String string2 = "";
        Collection collection = null;
        collection = this instanceof Database ? new Collection((Database)this) : new Collection((Collection)this);
        try {
            collection.setConfig(configuration);
            String string3 = collection.getName();
            if (string3 == null || string3.trim().equals("")) {
                throw new DBException(270, "No name specified");
            }
            if (this.getCollection(string3) != null) {
                throw new DBException(240, "Duplicate Collection '" + string3 + "'");
            }
            collection.create();
            this.collections.put(string3, collection);
            Configuration configuration2 = this.config.getChild(COLLECTIONS, true);
            configuration2.add(configuration);
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (Exception exception) {
            throw new DBException(270, "Error Creating Collection '" + string + "'");
        }
        return collection;
    }

    public void dispose() {
        if (this instanceof Collection) {
            try {
                ((Collection)this).close();
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }
    }
}

