/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.DocumentCache;
import org.dbxml.core.SystemCollection;
import org.dbxml.core.query.QueryEngine;
import org.dbxml.core.request.URIMapper;
import org.dbxml.core.security.DBSecurityManager;
import org.dbxml.core.security.LocalSecurityManager;
import org.dbxml.server.Configuration;
import org.dbxml.server.Kernel;
import org.dbxml.server.KernelAccess;
import org.dbxml.server.Named;
import org.dbxml.server.ObjectPool;
import org.dbxml.server.Poolable;
import org.dbxml.server.dbXMLException;

public final class Database
extends Collection
implements Named,
KernelAccess {
    private static final String DBROOT = "dbroot";
    private static final String SECURITY = "security";
    private static final String PACKAGE = "package";
    private static final String QUERYENGINE = "queryengine";
    private static final String NAME = "name";
    private static final Map databases = new HashMap();
    private DocumentCache docCache = new DocumentCache();
    private DBSecurityManager securityManager = null;
    private ObjectPool uriPool = new ObjectPool(){

        public Poolable createObject() {
            return new URIMapper();
        }
    };
    private SystemCollection sysCol = null;
    private boolean sysInit = false;
    private Kernel kernel = null;
    private QueryEngine engine = new QueryEngine(this);

    public static Database getDatabase(String string) {
        return (Database)databases.get(string);
    }

    public static String[] listDatabases() {
        return databases.keySet().toArray(new String[0]);
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setConfig(Configuration configuration) {
        this.config = configuration;
        this.name = configuration.getAttribute(NAME);
        this.setCanonicalName('/' + this.getName());
        this.setCollectionRoot(new File(configuration.getAttribute(DBROOT)));
        if (this.securityManager == null) {
            boolean bl = false;
            if (configuration.getAttribute(SECURITY).equals("false")) {
                bl = true;
            }
            this.securityManager = new LocalSecurityManager(this, bl);
        }
        try {
            Configuration configuration2 = configuration.getChild(QUERYENGINE);
            if (configuration2 != null) {
                this.engine.setConfig(configuration2);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        if (!this.sysInit) {
            this.sysCol = new SystemCollection(this);
            try {
                this.sysCol.init();
            }
            catch (dbXMLException dbXMLException2) {
                Debug.printStackTrace((Throwable)dbXMLException2);
            }
            this.collections.put(this.sysCol.getName(), this.sysCol);
            this.sysInit = true;
        }
        try {
            super.setConfig(configuration);
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        databases.put(this.getName(), this);
    }

    public SystemCollection getSystemCollection() {
        return this.sysCol;
    }

    public Database getDatabase() {
        return this;
    }

    public URIMapper getURIMapper() {
        return (URIMapper)this.uriPool.getObject();
    }

    public URIMapper getURIMapper(String string) throws DBException {
        try {
            URIMapper uRIMapper = (URIMapper)this.uriPool.getObject();
            uRIMapper.setURI(string);
            return uRIMapper;
        }
        catch (Exception exception) {
            throw new DBException(820, "Couldn't Parse URL: '" + string + "'");
        }
    }

    public DocumentCache getDocumentCache() {
        return this.docCache;
    }

    public QueryEngine getQueryEngine() {
        return this.engine;
    }

    public DBSecurityManager getSecurityManager() {
        return this.securityManager;
    }
}

