/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core;

import java.util.Map;
import java.util.WeakHashMap;
import org.dbxml.core.Collection;
import org.dbxml.core.data.Key;
import org.dbxml.xml.NodeSource;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentCache {
    private Map table = new WeakHashMap();

    public Document getDocument(Collection collection, Key key) {
        Object v = this.table.get(new CacheKey(collection, key));
        Document document = null;
        if (v instanceof Document) {
            document = (Document)v;
        } else if (v instanceof byte[]) {
            try {
                SymbolTable symbolTable = collection.getSymbols();
                NodeSource nodeSource = new NodeSource(collection, key);
                document = new DocumentImpl((byte[])v, symbolTable, nodeSource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return document;
    }

    public void putDocument(Collection collection, Key key, byte[] byArray) {
        CacheKey cacheKey = new CacheKey(collection, key);
        this.table.put(cacheKey, byArray);
    }

    public void putDocument(Collection collection, Key key, Document document) {
        CacheKey cacheKey = new CacheKey(collection, key);
        this.table.put(cacheKey, document);
    }

    public void removeDocument(Collection collection, Key key) {
        this.table.remove(new CacheKey(collection, key));
    }

    public static int getCacheControl(Document document) {
        String string = "cache";
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 7 && node.getNodeName().equals("dbxml-cache")) {
                string = node.getNodeValue().trim();
                break;
            }
            ++n2;
        }
        if (string != null) {
            if (string.equals("cache")) {
                return -1;
            }
            if (string.equals("no-cache")) {
                return 0;
            }
            return Integer.parseInt(string);
        }
        return -1;
    }

    private class CacheKey {
        private Collection col;
        private String strVal;
        private Key key;

        public CacheKey(Collection collection, Key key) {
            this.col = collection;
            this.key = key;
        }

        public Collection getCollection() {
            return this.col;
        }

        public Key getKey() {
            return this.key;
        }

        public String toString() {
            if (this.strVal == null) {
                this.strVal = this.col.getCanonicalDocumentName(this.key);
            }
            return this.strVal;
        }

        public int hashCode() {
            if (this.strVal == null) {
                this.strVal = this.col.getCanonicalDocumentName(this.key);
            }
            return this.strVal.hashCode();
        }

        public boolean equals(Object object) {
            CacheKey cacheKey = (CacheKey)object;
            if (this.col != cacheKey.col) {
                return false;
            }
            return this.key.equals(cacheKey.key);
        }
    }
}

