/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core;

import java.util.HashMap;
import java.util.Map;
import org.dbxml.core.DBException;
import org.dbxml.core.corba.db.APIException;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.xmldb.api.base.XMLDBException;

public abstract class FaultCodes
implements org.dbxml.core.corba.db.FaultCodes {
    private static final Map FaultMsg = new HashMap();

    private FaultCodes() {
    }

    private static void putCodeMessage(int n, String string) {
        FaultMsg.put(new Integer(n), string);
    }

    public static String getMessage(int n) {
        String string = (String)FaultMsg.get(new Integer(n));
        return string != null ? string : "";
    }

    public static APIException createAPIException(int n) {
        return new APIException(n, FaultCodes.getMessage(n), "");
    }

    public static APIException createAPIException(int n, String string) {
        return new APIException(n, FaultCodes.getMessage(n), string);
    }

    public static APIException createAPIException(Exception exception) {
        if (exception instanceof APIException) {
            return (APIException)((java.lang.Object)exception);
        }
        String string = exception.getMessage();
        if (string == null) {
            string = "";
        }
        if (exception instanceof RuntimeException) {
            return new APIException(2070, FaultCodes.getMessage(2070), string);
        }
        if (exception instanceof DBException) {
            DBException dBException = (DBException)((java.lang.Object)exception);
            return new APIException(dBException.faultCode, FaultCodes.getMessage(dBException.faultCode), string);
        }
        return new APIException(0, FaultCodes.getMessage(0), string);
    }

    public static XMLDBException createXMLDBException(Exception exception) {
        if (exception instanceof XMLDBException) {
            return (XMLDBException)((java.lang.Object)exception);
        }
        if (exception instanceof DBException) {
            DBException dBException = (DBException)((java.lang.Object)exception);
            return new XMLDBException(1, dBException.faultCode, FaultCodes.getMessage(dBException.faultCode));
        }
        if (exception instanceof APIException) {
            APIException aPIException = (APIException)((java.lang.Object)exception);
            return new XMLDBException(1, aPIException.faultCode, aPIException.faultMessage);
        }
        String string = exception.getMessage();
        if (string == null) {
            string = "";
        }
        int n = exception instanceof RuntimeException ? 2070 : 0;
        return new XMLDBException(1, n, string);
    }

    public static int getFaultCodeType(Exception exception) {
        int n = 0;
        if (exception instanceof DBException) {
            n = ((DBException)((java.lang.Object)exception)).faultCode;
        } else if (exception instanceof APIException) {
            n = ((APIException)((java.lang.Object)exception)).faultCode;
        }
        n %= 100;
        n -= n % 10;
        return n;
    }

    public static int getFaultCodeSeries(Exception exception) {
        int n = 0;
        if (exception instanceof DBException) {
            n = ((DBException)((java.lang.Object)exception)).faultCode;
        } else if (exception instanceof APIException) {
            n = ((APIException)((java.lang.Object)exception)).faultCode;
        }
        n -= n % 100;
        return n;
    }

    public static int getFaultCode(Exception exception) {
        if (exception instanceof DBException) {
            return ((DBException)((java.lang.Object)exception)).faultCode;
        }
        if (exception instanceof APIException) {
            return ((APIException)((java.lang.Object)exception)).faultCode;
        }
        return 0;
    }

    public static String getFaultMessage(Exception exception) {
        return FaultCodes.getMessage(FaultCodes.getFaultCode(exception));
    }

    public abstract Object _set_policy_override(Policy[] var1, SetOverrideType var2);

    public abstract DomainManager[] _get_domain_managers();

    public abstract Policy _get_policy(int var1);

    public abstract Request _create_request(Context var1, String var2, NVList var3, NamedValue var4, ExceptionList var5, ContextList var6);

    public abstract Request _create_request(Context var1, String var2, NVList var3, NamedValue var4);

    public abstract Request _request(String var1);

    public abstract Object _get_interface_def();

    public abstract void _release();

    public abstract Object _duplicate();

    public abstract int _hash(int var1);

    public abstract boolean _non_existent();

    public abstract boolean _is_equivalent(Object var1);

    public abstract boolean _is_a(String var1);

    static {
        FaultCodes.putCodeMessage(0, "Unknown");
        FaultCodes.putCodeMessage(40, "General Error");
        FaultCodes.putCodeMessage(70, "Critical Error");
        FaultCodes.putCodeMessage(90, "Fatal Error");
        FaultCodes.putCodeMessage(100, "XMLObject Not Found");
        FaultCodes.putCodeMessage(101, "XMLObject Method Not Found");
        FaultCodes.putCodeMessage(140, "XMLObject Null Result");
        FaultCodes.putCodeMessage(141, "XMLObject Invalid Result");
        FaultCodes.putCodeMessage(142, "XMLObject Duplicate Object");
        FaultCodes.putCodeMessage(170, "XMLObject Runtime Exception");
        FaultCodes.putCodeMessage(171, "XMLObject Class Format Error");
        FaultCodes.putCodeMessage(172, "XMLObject Invalid Context");
        FaultCodes.putCodeMessage(173, "XMLObject Cannot Create");
        FaultCodes.putCodeMessage(200, "Collection Not Found");
        FaultCodes.putCodeMessage(201, "Collection Document Not Found");
        FaultCodes.putCodeMessage(240, "Collection Duplicated");
        FaultCodes.putCodeMessage(241, "Collection Null Result");
        FaultCodes.putCodeMessage(242, "Collection No Filer");
        FaultCodes.putCodeMessage(242, "Collection No IndexManager");
        FaultCodes.putCodeMessage(243, "Collection Document Malformed");
        FaultCodes.putCodeMessage(244, "Collection Cannot Store");
        FaultCodes.putCodeMessage(245, "Collection Cannot Retrieve");
        FaultCodes.putCodeMessage(246, "Collection Read-only");
        FaultCodes.putCodeMessage(247, "Collection Closed");
        FaultCodes.putCodeMessage(270, "Collection Cannot Create");
        FaultCodes.putCodeMessage(271, "Collection Cannot Drop");
        FaultCodes.putCodeMessage(300, "Index Value Not Found");
        FaultCodes.putCodeMessage(301, "Index Not Found");
        FaultCodes.putCodeMessage(340, "Index Matches Not Found");
        FaultCodes.putCodeMessage(341, "Index Duplicate Index");
        FaultCodes.putCodeMessage(370, "Index Not Supported");
        FaultCodes.putCodeMessage(371, "Index Style Not Found");
        FaultCodes.putCodeMessage(372, "Index Corrupted");
        FaultCodes.putCodeMessage(373, "Index Cannot Create");
        FaultCodes.putCodeMessage(400, "Transaction Document Locked");
        FaultCodes.putCodeMessage(440, "Transaction No Context");
        FaultCodes.putCodeMessage(441, "Transaction Not Active");
        FaultCodes.putCodeMessage(470, "Transaction Not Supported");
        FaultCodes.putCodeMessage(500, "Database No Parent");
        FaultCodes.putCodeMessage(570, "Database Cannot Drop");
        FaultCodes.putCodeMessage(600, "Query Null Result");
        FaultCodes.putCodeMessage(640, "Query Compilation Error");
        FaultCodes.putCodeMessage(641, "Query Processing Error");
        FaultCodes.putCodeMessage(670, "Query Not Supported");
        FaultCodes.putCodeMessage(671, "Query Style Not Found");
        FaultCodes.putCodeMessage(770, "Security Invalid User");
        FaultCodes.putCodeMessage(771, "Security Invalid Group");
        FaultCodes.putCodeMessage(772, "Security Invalid Access");
        FaultCodes.putCodeMessage(773, "Security Invalid Credentials");
        FaultCodes.putCodeMessage(800, "URI Empty");
        FaultCodes.putCodeMessage(801, "URI Null");
        FaultCodes.putCodeMessage(820, "URI Parse Error");
        FaultCodes.putCodeMessage(2070, "Java Runtime Error");
    }
}

