/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core;

import java.io.File;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.Database;
import org.dbxml.server.Configuration;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.SymbolTableSymbols;
import org.dbxml.xml.dom.DOMParser;
import org.w3c.dom.Document;

public final class SystemCollection
extends Collection {
    public static final String CLASSGEN = "classgen";
    public static final String SYSCOL = "system";
    public static final String SYMBOLS = "SysSymbols";
    public static final String OBJECTS = "SysObjects";
    public static final String CONFIGS = "SysConfig";
    public static final String USERS = "SysUsers";
    public static final String GROUPS = "SysGroups";
    public static final String ACCESS = "SysAccess";
    private String classGen = "./classgen";

    public SystemCollection(Database database) {
        super(database);
    }

    void init() throws DBException {
        File file = new File(this.getDatabase().getCollectionRoot(), SYSCOL);
        File file2 = new File(System.getProperty("dbxml.home"), "config");
        this.classGen = this.getDatabase().getConfig().getAttribute(CLASSGEN, this.classGen);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string = "<collection name=\"system\">   <collections>      <collection name=\"SysSymbols\" compressed=\"true\">         <filer class=\"org.dbxml.core.filer.BTreeFiler\" />" + SymbolTableSymbols.getDefinition() + "      </collection>" + "      <collection name=\"" + OBJECTS + "\" compressed=\"true\">" + "         <filer class=\"org.dbxml.core.filer.BTreeFiler\" />" + "      </collection>" + "      <collection name=\"" + CONFIGS + "\" compressed=\"false\" cache=\"false\" >" + "         <filer class=\"org.dbxml.core.filer.FSFiler\"" + "                location=\"" + file2.getAbsolutePath() + "\"" + "                ext=\"xml xsl xsd\" />" + "      </collection>" + "      <collection name=\"" + USERS + "\" compressed=\"true\">" + "         <filer class=\"org.dbxml.core.filer.BTreeFiler\" />" + "      </collection>" + "      <collection name=\"" + GROUPS + "\" compressed=\"true\">" + "         <filer class=\"org.dbxml.core.filer.BTreeFiler\" />" + "      </collection>" + "      <collection name=\"" + ACCESS + "\" compressed=\"true\">" + "         <filer class=\"org.dbxml.core.filer.BTreeFiler\" />" + "      </collection>" + "   </collections>" + "   <xmlobjects>" + "      <xmlobject class=\"org.dbxml.core.system.Sequencer\" name=\"sequencer\" />" + "   </xmlobjects>" + "</collection>";
        try {
            Document document = DOMParser.toDocument(string);
            Configuration configuration = new Configuration(document.getDocumentElement(), false);
            this.setConfig(configuration);
        }
        catch (Exception exception) {
            Debug.println((Object)"\u0007FATAL ERROR: Generating System Collection 'system'");
            Debug.printStackTrace((Throwable)exception);
            System.exit(1);
        }
    }

    private String getSymbolTableName(Collection collection) {
        String string = collection.getCanonicalName();
        int n = string.indexOf(47, 1);
        string = string.substring(n + 1);
        return string.replace('/', '_');
    }

    public SymbolTable loadSymbols(Collection collection) throws DBException {
        String string = this.getSymbolTableName(collection);
        Collection collection2 = this.getCollection(SYMBOLS);
        SymbolTable symbolTable = (SymbolTable)collection2.getObject(string);
        if (symbolTable == null) {
            symbolTable = new SymbolTable();
            this.saveSymbols(collection, symbolTable);
        }
        return symbolTable;
    }

    public void saveSymbols(Collection collection, SymbolTable symbolTable) throws DBException {
        String string = this.getSymbolTableName(collection);
        Collection collection2 = this.getCollection(SYMBOLS);
        if (symbolTable != null) {
            collection2.setObject(string, symbolTable);
            symbolTable.setDirty(false);
        }
    }
}

