/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.corba;

import org.dbxml.Debug;
import org.dbxml.core.FaultCodes;
import org.dbxml.core.corba.CollectionManagerServant;
import org.dbxml.core.corba.DocumentSetServant;
import org.dbxml.core.corba.EncodedBufferConverter;
import org.dbxml.core.corba.SymbolSerializer;
import org.dbxml.core.corba.db.APIException;
import org.dbxml.core.corba.db.Collection;
import org.dbxml.core.corba.db.CollectionManager;
import org.dbxml.core.corba.db.CollectionPOA;
import org.dbxml.core.corba.db.DocumentSet;
import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.core.corba.db.NamedVal;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.NodeSet;
import org.dbxml.core.objects.XMLObjectException;
import org.dbxml.core.request.URIMapper;
import org.dbxml.xml.NamespaceMap;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.SymbolTableSymbols;
import org.dbxml.xml.dom.DBNode;
import org.dbxml.xml.dom.DOMCompressor;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CollectionServant
extends CollectionPOA {
    private static final byte[] EmptyBytes = new byte[0];
    private static final SymbolTableSymbols hcSyms = SymbolTableSymbols.getInstance();
    private SymbolSerializer syms = null;
    org.dbxml.core.Collection collection;

    public CollectionServant(org.dbxml.core.Collection collection) {
        this.collection = collection;
        try {
            this.syms = new SymbolSerializer(collection.getSymbols());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDocument(String string, EncodedBuffer encodedBuffer) throws APIException {
        Document document = EncodedBufferConverter.convertToDocument(encodedBuffer);
        if (document == null) {
            throw FaultCodes.createAPIException(243, "Unable to parse Document");
        }
        try {
            this.collection.setDocument(string, document);
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public String getName() throws APIException {
        try {
            return this.collection.getName();
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public String getCanonicalName() throws APIException {
        try {
            return this.collection.getCanonicalName();
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public CollectionManager getCollectionManager() throws APIException {
        try {
            return new CollectionManagerServant(this.collection)._this(this._orb());
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public Collection getParentCollection() throws APIException {
        try {
            if (this.collection.getParentCollection() != null) {
                return new CollectionServant(this.collection.getParentCollection())._this(this._orb());
            }
            throw FaultCodes.createAPIException(500, "Root Collection has no parent");
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public Collection getCollection(String string) throws APIException {
        org.dbxml.core.Collection collection = null;
        try {
            collection = this.collection.getCollection(string);
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
        if (collection != null) {
            return new CollectionServant(collection)._this(this._orb());
        }
        throw FaultCodes.createAPIException(200);
    }

    public EncodedBuffer getDocument(String string, long l) throws APIException {
        try {
            Document document = this.collection.getDocument(string);
            if (document == null) {
                throw FaultCodes.createAPIException(201);
            }
            if (l != -1L && this.syms != null) {
                return this.syms.convertFromDocument(document, l);
            }
            return EncodedBufferConverter.convertFromDocument(document);
        }
        catch (APIException aPIException) {
            throw aPIException;
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public DocumentSet getDocuments() throws APIException {
        try {
            return new DocumentSetServant(this.collection.getDocumentSet(), this.syms)._this(this._orb());
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public int getDocumentCount() throws APIException {
        try {
            return (int)this.collection.getDocumentCount();
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public String[] listCollections() throws APIException {
        try {
            String[] stringArray = this.collection.listCollections();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
            throw FaultCodes.createAPIException(exception);
        }
    }

    public String insertDocument(String string, EncodedBuffer encodedBuffer) throws APIException {
        Document document = EncodedBufferConverter.convertToDocument(encodedBuffer);
        if (document == null) {
            throw FaultCodes.createAPIException(243, "Unable to parse Document");
        }
        try {
            if (string.equals("")) {
                return this.collection.insertDocument(document).toString();
            }
            this.collection.insertDocument(string, document);
            return string;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
            throw FaultCodes.createAPIException(exception);
        }
    }

    public void removeDocument(String string) throws APIException {
        try {
            this.collection.remove(string);
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public String[] listDocuments() throws APIException {
        try {
            return this.collection.listDocuments();
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public String createNewOID() throws APIException {
        try {
            Key key = this.collection.createNewOID();
            return key.toString();
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    private EncodedBuffer queryWrapper(NodeSet nodeSet, long l) throws Exception {
        Object object;
        DocumentImpl documentImpl = new DocumentImpl();
        if (this.syms != null) {
            documentImpl.setSymbols(this.syms.getSymbols());
        }
        Element element = documentImpl.createElement("result");
        documentImpl.appendChild(element);
        int n = 0;
        while (nodeSet != null && nodeSet.hasMoreNodes()) {
            object = nodeSet.getNextNode();
            if (object.getNodeType() == 9) {
                object = ((Document)object).getDocumentElement();
            }
            if (object instanceof DBNode) {
                ((DBNode)object).expandSource();
            }
            element.appendChild(documentImpl.importNode((Node)object, true));
            ++n;
        }
        element.setAttribute("count", Integer.toString(n));
        if (l != -1L && this.syms != null) {
            object = this.syms.getSymbols();
            byte[] byArray = DOMCompressor.Compress(documentImpl, (SymbolTable)object);
            documentImpl = new DocumentImpl(byArray, (SymbolTable)object, null);
            return this.syms.convertFromDocument(documentImpl, l);
        }
        return EncodedBufferConverter.convertFromDocument(documentImpl);
    }

    public EncodedBuffer queryCollection(String string, String string2, NamedVal[] namedValArray, long l) throws APIException {
        try {
            NamespaceMap namespaceMap = null;
            if (namedValArray.length > 0) {
                namespaceMap = new NamespaceMap();
                int n = 0;
                while (n < namedValArray.length) {
                    namespaceMap.setNamespace(namedValArray[n].nam, namedValArray[n].val);
                    ++n;
                }
            }
            NodeSet nodeSet = this.collection.queryCollection(string, string2, namespaceMap);
            return this.queryWrapper(nodeSet, l);
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public EncodedBuffer queryDocument(String string, String string2, NamedVal[] namedValArray, String string3, long l) throws APIException {
        try {
            NamespaceMap namespaceMap = null;
            if (namedValArray.length > 0) {
                namespaceMap = new NamespaceMap();
                int n = 0;
                while (n < namedValArray.length) {
                    namespaceMap.setNamespace(namedValArray[n].nam, namedValArray[n].val);
                    ++n;
                }
            }
            NodeSet nodeSet = this.collection.queryDocument(string, string2, namespaceMap, string3);
            return this.queryWrapper(nodeSet, l);
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public EncodedBuffer invokeXMLObject(String string) throws APIException {
        URIMapper uRIMapper = null;
        try {
            uRIMapper = this.collection.getDatabase().getURIMapper(string);
            uRIMapper.setURI(string);
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
        Object object = null;
        if (uRIMapper.getObjectType() == 4) {
            try {
                object = uRIMapper.invokeRequest();
            }
            catch (XMLObjectException xMLObjectException) {
                throw FaultCodes.createAPIException((Exception)((Object)xMLObjectException));
            }
            if (object == null) {
                throw FaultCodes.createAPIException(140);
            }
            if (object instanceof Node) {
                return EncodedBufferConverter.convertFromDocument((Node)object);
            }
            String string2 = object.toString();
            EncodedBuffer encodedBuffer = new EncodedBuffer(-1L, EmptyBytes, string2.getBytes());
            return encodedBuffer;
        }
        throw FaultCodes.createAPIException(100);
    }

    public void remove() {
        try {
            this._poa().deactivate_object(this._object_id());
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }
}

