/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.corba;

import org.dbxml.Debug;
import org.dbxml.core.FaultCodes;
import org.dbxml.core.corba.EncodedBufferConverter;
import org.dbxml.core.corba.SymbolSerializer;
import org.dbxml.core.corba.db.APIException;
import org.dbxml.core.corba.db.DocumentSetPOA;
import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.core.data.DocumentSet;
import org.w3c.dom.Document;

public class DocumentSetServant
extends DocumentSetPOA {
    SymbolSerializer syms = null;
    DocumentSet documentSet;

    public DocumentSetServant(DocumentSet documentSet) {
        this.documentSet = documentSet;
    }

    public DocumentSetServant(DocumentSet documentSet, SymbolSerializer symbolSerializer) {
        this.documentSet = documentSet;
        this.syms = symbolSerializer;
    }

    public boolean hasMoreDocuments() throws APIException {
        try {
            return this.documentSet.hasMoreDocuments();
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public EncodedBuffer getNextDocument(long l) throws APIException {
        try {
            Document document = this.documentSet.getNextDocument();
            if (l != -1L && this.syms != null) {
                return this.syms.convertFromDocument(document, l);
            }
            return EncodedBufferConverter.convertFromDocument(document);
        }
        catch (Exception exception) {
            throw FaultCodes.createAPIException(exception);
        }
    }

    public void remove() {
        try {
            this._poa().deactivate_object(this._object_id());
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }
}

