/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.corba;

import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.server.Configuration;
import org.dbxml.xml.TextWriter;
import org.dbxml.xml.dom.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EncodedBufferConverter {
    private static final byte[] EmptyBytes = new byte[0];

    public static Configuration convertToConfiguration(EncodedBuffer encodedBuffer) {
        Configuration configuration = null;
        Document document = EncodedBufferConverter.getDocument(encodedBuffer);
        configuration = new Configuration(document.getDocumentElement(), false);
        return configuration;
    }

    public static Document convertToDocument(EncodedBuffer encodedBuffer) {
        return EncodedBufferConverter.getDocument(encodedBuffer);
    }

    public static EncodedBuffer convertFromDocument(Node node) {
        EncodedBuffer encodedBuffer = new EncodedBuffer();
        encodedBuffer.sym = EmptyBytes;
        encodedBuffer.buf = TextWriter.toString(node).getBytes();
        encodedBuffer.stamp = -1L;
        return encodedBuffer;
    }

    private static Document getDocument(EncodedBuffer encodedBuffer) {
        String string = new String(encodedBuffer.buf);
        try {
            return DOMParser.toDocument(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void remove() {
    }
}

