/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.corba;

import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.SymbolTableSymbols;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;

public final class SymbolDeserializer {
    private static final byte[] EmptyBytes = new byte[0];
    private static final SymbolTableSymbols hcSyms = SymbolTableSymbols.getInstance();
    private static final Document elemFactory = new DocumentImpl();
    private SymbolTable syms = null;
    private long lastMod = 0L;

    public Document convertToDocument(EncodedBuffer encodedBuffer) {
        SymbolTable symbolTable = this.getSymbols(encodedBuffer);
        return new DocumentImpl(encodedBuffer.buf, symbolTable, null);
    }

    public SymbolTable getSymbols(EncodedBuffer encodedBuffer) {
        if (encodedBuffer.stamp != this.lastMod) {
            this.lastMod = encodedBuffer.stamp;
            DocumentImpl documentImpl = new DocumentImpl(encodedBuffer.sym, hcSyms, null);
            if (this.syms == null) {
                this.syms = new SymbolTable();
            }
            SymbolTable symbolTable = this.syms;
            synchronized (symbolTable) {
                this.syms.streamFromXML(documentImpl.getDocumentElement());
            }
        }
        return this.syms;
    }

    public long getLastModified() {
        return this.lastMod;
    }
}

