/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.corba;

import org.dbxml.Debug;
import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.SymbolTableSymbols;
import org.dbxml.xml.dom.CompressedDocument;
import org.dbxml.xml.dom.DOMCompressor;
import org.dbxml.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SymbolSerializer {
    private static final byte[] EmptyBytes = new byte[0];
    private static final SymbolTableSymbols hcSyms = SymbolTableSymbols.getInstance();
    private static final DocumentImpl elemFactory = new DocumentImpl();
    private SymbolTable syms = null;
    private long lastMod = 0L;
    private byte[] symBytes = null;

    public SymbolSerializer(SymbolTable symbolTable) {
        this.syms = symbolTable;
        elemFactory.setSymbols(symbolTable);
    }

    public EncodedBuffer getSymBuffer() {
        long l = this.syms.getLastModified();
        if (l > this.lastMod) {
            SymbolTable symbolTable = this.syms;
            synchronized (symbolTable) {
                Element element = this.syms.streamToXML(elemFactory);
                try {
                    this.symBytes = DOMCompressor.Compress(element, hcSyms);
                    this.lastMod = l;
                }
                catch (Exception exception) {
                    Debug.println((Object)"Problem compressing Symbol Table!  Very Bad!");
                }
            }
        }
        return new EncodedBuffer(l, this.symBytes, null);
    }

    public EncodedBuffer convertFromDocument(Document document, long l) {
        EncodedBuffer encodedBuffer = this.getSymBuffer();
        byte[] byArray = ((CompressedDocument)document).getDataBytes();
        encodedBuffer.buf = byArray;
        if (encodedBuffer.stamp == l) {
            encodedBuffer.sym = EmptyBytes;
        }
        return encodedBuffer;
    }

    public SymbolTable getSymbols() {
        return this.syms;
    }

    public long getLastModified() {
        return this.lastMod;
    }
}

