/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.corba.db;

import org.dbxml.core.corba.db.APIException;
import org.dbxml.core.corba.db.APIExceptionHelper;
import org.dbxml.core.corba.db.DocumentSet;
import org.dbxml.core.corba.db.DocumentSetHelper;
import org.dbxml.core.corba.db.DocumentSetOperations;
import org.dbxml.core.corba.db.EncodedBuffer;
import org.dbxml.core.corba.db.EncodedBufferHelper;
import org.dbxml.core.corba.db.TimestampHelper;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class DocumentSetPOA
extends Servant
implements DocumentSetOperations,
InvokeHandler {
    private static String[] _ids_list = new String[]{"IDL:org/dbxml/core/corba/db/DocumentSet:1.0", "IDL:org/dbxml/core/corba/db/ServantManagement:1.0"};

    public DocumentSet _this() {
        return DocumentSetHelper.narrow(this._this_object());
    }

    public DocumentSet _this(ORB oRB) {
        return DocumentSetHelper.narrow(this._this_object(oRB));
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return _ids_list;
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) {
        OutputStream outputStream = null;
        if (string.equals("hasMoreDocuments")) {
            try {
                boolean bl = this.hasMoreDocuments();
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(bl);
            }
            catch (APIException aPIException) {
                outputStream = responseHandler.createExceptionReply();
                APIExceptionHelper.write(outputStream, aPIException);
            }
            return outputStream;
        }
        if (string.equals("getNextDocument")) {
            long l = TimestampHelper.read(inputStream);
            try {
                EncodedBuffer encodedBuffer = this.getNextDocument(l);
                outputStream = responseHandler.createReply();
                EncodedBufferHelper.write(outputStream, encodedBuffer);
            }
            catch (APIException aPIException) {
                outputStream = responseHandler.createExceptionReply();
                APIExceptionHelper.write(outputStream, aPIException);
            }
            return outputStream;
        }
        if (string.equals("remove")) {
            this.remove();
            outputStream = responseHandler.createReply();
            return outputStream;
        }
        throw new BAD_OPERATION();
    }

    public abstract EncodedBuffer getNextDocument(long var1) throws APIException;

    public abstract boolean hasMoreDocuments() throws APIException;

    public abstract void remove();
}

