/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.data;

import org.dbxml.core.data.Value;

public final class Key
extends Value {
    private int hash = 0;

    public Key(Value value) {
        super(value);
        this.calculateHash();
    }

    public Key(byte[] byArray) {
        super(byArray);
        this.calculateHash();
    }

    public Key(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.calculateHash();
    }

    public Key(String string) {
        super(string);
        this.calculateHash();
    }

    private void calculateHash() {
        this.hash = 0;
        int n = this.pos + this.len;
        int n2 = this.pos;
        while (n2 < n) {
            this.hash = this.hash << 5 ^ this.data[n2];
            this.hash %= 1234567891;
            ++n2;
        }
        this.hash = Math.abs(this.hash);
    }

    public int getHash() {
        return this.hash;
    }

    public boolean equals(Value value) {
        if (value instanceof Key) {
            Key key = (Key)value;
            return this.hash == key.hash ? this.compareTo(key) == 0 : false;
        }
        return super.equals(value);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object instanceof Key) {
            return this.equals((Key)object);
        }
        return super.equals(object);
    }
}

