/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Value
implements Comparable {
    protected byte[] data = null;
    protected int pos = 0;
    protected int len = -1;

    private Value() {
    }

    public Value(Value value) {
        this.data = value.data;
        this.pos = value.pos;
        this.len = value.len;
    }

    public Value(byte[] byArray) {
        this.data = byArray;
        this.len = byArray.length;
    }

    public Value(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.pos = n;
        this.len = n2;
    }

    public Value(String string) {
        this(string.getBytes());
    }

    public final byte[] getData() {
        if (this.len != this.data.length) {
            byte[] byArray = new byte[this.len];
            System.arraycopy(this.data, this.pos, byArray, 0, this.len);
            return byArray;
        }
        return this.data;
    }

    public final int getLength() {
        return this.len;
    }

    public final InputStream getInputStream() {
        return new ByteArrayInputStream(this.data, this.pos, this.len);
    }

    public final void streamTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.data, this.pos, this.len);
    }

    public final void copyTo(byte[] byArray, int n) {
        System.arraycopy(this.data, this.pos, byArray, n, this.len);
    }

    public final String toString() {
        return new String(this.getData());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Value value) {
        return this.len == value.len ? this.compareTo(value) == 0 : false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Value) {
            return this.equals((Value)object);
        }
        return this.equals(new Value(object.toString()));
    }

    public final int compareTo(Value value) {
        byte[] byArray = value.data;
        int n = value.pos;
        int n2 = value.len;
        int n3 = this.len > n2 ? n2 : this.len;
        int n4 = 0;
        while (n4 < n3) {
            byte by = this.data[this.pos + n4];
            byte by2 = byArray[n + n4];
            if (by != by2) {
                short s = (short)(by >>> 0);
                short s2 = (short)(by2 >>> 0);
                return s > s2 ? n4 + 1 : -(n4 + 1);
            }
            ++n4;
        }
        if (this.len == n2) {
            return 0;
        }
        return this.len > n2 ? n3 + 1 : -(n3 + 1);
    }

    public final int compareTo(Object object) {
        if (object instanceof Value) {
            return this.compareTo((Value)object);
        }
        return this.compareTo(new Value(object.toString()));
    }

    public final boolean startsWith(Value value) {
        if (this.len < value.len) {
            return false;
        }
        byte[] byArray = value.data;
        int n = value.pos;
        int n2 = 0;
        while (n2 < value.len) {
            if (this.data[n2 + this.pos] != byArray[n2 + n]) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

