/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.filer;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import org.dbxml.Debug;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.BTreeCorruptException;
import org.dbxml.core.filer.BTreeException;
import org.dbxml.core.filer.BTreeNotFoundException;
import org.dbxml.core.filer.Paged;
import org.dbxml.core.filer.Streamable;
import org.dbxml.core.indexer.IndexQuery;

public class BTree
extends Paged {
    protected static final byte LEAF = 1;
    protected static final byte BRANCH = 2;
    protected static final byte STREAM = 3;
    private Map cache = new WeakHashMap();
    private BTreeFileHeader fileHeader = (BTreeFileHeader)this.getFileHeader();
    private BTreeRootInfo rootInfo;
    private BTreeNode rootNode;

    public BTree() {
        this.fileHeader.setPageCount(1L);
        this.fileHeader.setTotalCount(1L);
    }

    public BTree(File file) {
        this();
        this.setFile(file);
    }

    public boolean open() throws DBException {
        if (super.open()) {
            long l = this.fileHeader.getRootPage();
            this.rootInfo = new BTreeRootInfo(l);
            this.rootNode = this.getBTreeNode(this.rootInfo, l, null);
            return true;
        }
        return false;
    }

    public boolean create() throws DBException {
        if (super.create()) {
            try {
                long l = this.fileHeader.getRootPage();
                this.rootInfo = new BTreeRootInfo(l);
                this.rootNode = new BTreeNode(this.rootInfo, this.getPage(l));
                this.rootNode.ph.setStatus((byte)1);
                this.rootNode.setValues(new Value[0]);
                this.rootNode.setPointers(new long[0]);
                this.rootNode.write();
                return true;
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }
        return false;
    }

    public long addValue(Value value, long l) throws IOException, BTreeException {
        return this.getRootNode().addValue(value, l);
    }

    public long addValue(BTreeRootInfo bTreeRootInfo, Value value, long l) throws IOException, BTreeException {
        return this.getRootNode(bTreeRootInfo).addValue(value, l);
    }

    public long removeValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().removeValue(value);
    }

    public long removeValue(BTreeRootInfo bTreeRootInfo, Value value) throws IOException, BTreeException {
        return this.getRootNode(bTreeRootInfo).removeValue(value);
    }

    public long findValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().findValue(value);
    }

    public long findValue(BTreeRootInfo bTreeRootInfo, Value value) throws IOException, BTreeException {
        return this.getRootNode(bTreeRootInfo).findValue(value);
    }

    public void query(IndexQuery indexQuery, BTreeCallback bTreeCallback) throws IOException, BTreeException {
        this.getRootNode().query(indexQuery, bTreeCallback);
    }

    public void query(BTreeRootInfo bTreeRootInfo, IndexQuery indexQuery, BTreeCallback bTreeCallback) throws IOException, BTreeException {
        this.getRootNode(bTreeRootInfo).query(indexQuery, bTreeCallback);
    }

    protected final BTreeRootInfo createBTreeRoot(Value value) throws IOException, BTreeException {
        BTreeNode bTreeNode = this.createBTreeNode(this.rootInfo, (byte)1, null);
        bTreeNode.write();
        long l = bTreeNode.page.getPageNum();
        this.addValue(value, l);
        return new BTreeRootInfo(value, l);
    }

    protected final BTreeRootInfo createBTreeRoot(BTreeRootInfo bTreeRootInfo, Value value) throws IOException, BTreeException {
        BTreeNode bTreeNode = this.createBTreeNode(bTreeRootInfo, (byte)1, null);
        bTreeNode.write();
        long l = bTreeNode.page.getPageNum();
        this.addValue(value, l);
        return new BTreeRootInfo(bTreeRootInfo, value, l);
    }

    protected final BTreeRootInfo findBTreeRoot(Value value) throws IOException, BTreeException {
        long l = this.findValue(value);
        return new BTreeRootInfo(value, l);
    }

    protected final BTreeRootInfo findBTreeRoot(BTreeRootInfo bTreeRootInfo, Value value) throws IOException, BTreeException {
        long l = this.findValue(bTreeRootInfo, value);
        return new BTreeRootInfo(bTreeRootInfo, value, l);
    }

    protected final void setRootNode(BTreeRootInfo bTreeRootInfo, BTreeNode bTreeNode) throws IOException, BTreeException {
        BTreeRootInfo bTreeRootInfo2 = bTreeRootInfo.getParent();
        if (bTreeRootInfo2 == null) {
            this.rootNode = bTreeNode;
            long l = this.rootNode.page.getPageNum();
            this.rootInfo.setPage(l);
            this.fileHeader.setRootPage(l);
            this.fileHeader.write();
        } else {
            long l = bTreeNode.page.getPageNum();
            bTreeRootInfo.setPage(l);
            this.addValue(bTreeRootInfo2, bTreeRootInfo.name, l);
        }
    }

    protected final void setRootNode(BTreeNode bTreeNode) throws IOException, BTreeException {
        this.setRootNode(this.rootInfo, bTreeNode);
    }

    protected final BTreeNode getRootNode(BTreeRootInfo bTreeRootInfo) {
        if (bTreeRootInfo.page == this.rootInfo.page) {
            return this.rootNode;
        }
        return this.getBTreeNode(bTreeRootInfo, bTreeRootInfo.getPage(), null);
    }

    protected final BTreeNode getRootNode() {
        return this.rootNode;
    }

    private BTreeNode getBTreeNode(BTreeRootInfo bTreeRootInfo, long l, BTreeNode bTreeNode) {
        try {
            Long l2 = new Long(l);
            BTreeNode bTreeNode2 = (BTreeNode)this.cache.get(l2);
            if (bTreeNode2 == null) {
                Paged.Page page = this.getPage(l2);
                bTreeNode2 = new BTreeNode(bTreeRootInfo, page, bTreeNode);
                bTreeNode2.read();
            } else {
                bTreeNode2.root = bTreeRootInfo;
                bTreeNode2.parent = bTreeNode;
            }
            return bTreeNode2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BTreeNode createBTreeNode(BTreeRootInfo bTreeRootInfo, byte by, BTreeNode bTreeNode) {
        try {
            Paged.Page page = this.getFreePage();
            BTreeNode bTreeNode2 = new BTreeNode(bTreeRootInfo, page, bTreeNode);
            bTreeNode2.ph.setStatus(by);
            bTreeNode2.setValues(new Value[0]);
            bTreeNode2.setPointers(new long[0]);
            return bTreeNode2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Paged.FileHeader createFileHeader() {
        return new BTreeFileHeader();
    }

    public Paged.FileHeader createFileHeader(boolean bl) throws IOException {
        return new BTreeFileHeader(bl);
    }

    public Paged.FileHeader createFileHeader(long l) {
        return new BTreeFileHeader(l);
    }

    public Paged.FileHeader createFileHeader(long l, int n) {
        return new BTreeFileHeader(l, n);
    }

    public Paged.PageHeader createPageHeader() {
        return new BTreePageHeader();
    }

    protected class BTreePageHeader
    extends Paged.PageHeader {
        private short valueCount = 0;

        public BTreePageHeader() {
            super(BTree.this);
        }

        public BTreePageHeader(DataInputStream dataInputStream) throws IOException {
            super(BTree.this, dataInputStream);
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            super.read(dataInputStream);
            if (this.getStatus() == 0) {
                return;
            }
            this.valueCount = dataInputStream.readShort();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeShort(this.valueCount);
        }

        public final void setValueCount(short s) {
            this.valueCount = s;
            this.setDirty();
        }

        public final short getValueCount() {
            return this.valueCount;
        }

        public final short getPointerCount() {
            if (this.getStatus() == 2) {
                return (short)(this.valueCount + 1);
            }
            return this.valueCount;
        }
    }

    protected class BTreeFileHeader
    extends Paged.FileHeader {
        private long rootPage = 0L;

        public BTreeFileHeader() {
            super(BTree.this);
        }

        public BTreeFileHeader(long l) {
            super((Paged)BTree.this, l);
        }

        public BTreeFileHeader(long l, int n) {
            super(BTree.this, l, n);
        }

        public BTreeFileHeader(boolean bl) throws IOException {
            super((Paged)BTree.this, bl);
        }

        public void read(RandomAccessFile randomAccessFile) throws IOException {
            super.read(randomAccessFile);
            this.rootPage = randomAccessFile.readLong();
        }

        public void write(RandomAccessFile randomAccessFile) throws IOException {
            super.write(randomAccessFile);
            randomAccessFile.writeLong(this.rootPage);
        }

        public final void setRootPage(long l) {
            this.rootPage = l;
            this.setDirty();
        }

        public final long getRootPage() {
            return this.rootPage;
        }
    }

    private final class BTreeNode {
        private BTreeRootInfo root;
        private Paged.Page page;
        private BTreePageHeader ph;
        private Value[] values;
        private long[] ptrs;
        private BTreeNode parent;

        public BTreeNode(BTreeRootInfo bTreeRootInfo, Paged.Page page, BTreeNode bTreeNode) {
            this.root = bTreeRootInfo;
            this.page = page;
            this.parent = bTreeNode;
            this.ph = (BTreePageHeader)page.getPageHeader();
        }

        public BTreeNode(BTreeRootInfo bTreeRootInfo, Paged.Page page) {
            this.root = bTreeRootInfo;
            this.page = page;
            this.ph = (BTreePageHeader)page.getPageHeader();
        }

        public void setValues(Value[] valueArray) {
            this.values = valueArray;
            this.ph.setValueCount((short)valueArray.length);
        }

        public Value[] getValues() {
            return this.values;
        }

        public void setPointers(long[] lArray) {
            this.ptrs = lArray;
        }

        public long[] getPointers() {
            return this.ptrs;
        }

        public void read() throws IOException {
            int n;
            Value value = BTree.this.readValue(this.page);
            DataInputStream dataInputStream = new DataInputStream(value.getInputStream());
            this.values = new Value[this.ph.getValueCount()];
            int n2 = 0;
            while (n2 < this.values.length) {
                n = dataInputStream.readShort();
                byte[] byArray = new byte[n];
                dataInputStream.read(byArray);
                this.values[n2] = new Value(byArray);
                ++n2;
            }
            this.ptrs = new long[this.ph.getPointerCount()];
            n = 0;
            while (n < this.ptrs.length) {
                this.ptrs[n] = dataInputStream.readLong();
                ++n;
            }
            BTree.this.cache.put(new Long(this.page.getPageNum()), this);
        }

        public void write() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(BTree.this.fileHeader.getWorkSize());
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n = 0;
            while (n < this.values.length) {
                dataOutputStream.writeShort(this.values[n].getLength());
                this.values[n].streamTo(dataOutputStream);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.ptrs.length) {
                dataOutputStream.writeLong(this.ptrs[n2]);
                ++n2;
            }
            BTree.this.writeValue(this.page, new Value(byteArrayOutputStream.toByteArray()));
            BTree.this.fileHeader.write();
            BTree.this.cache.put(new Long(this.page.getPageNum()), this);
        }

        public BTreeNode getChildNode(int n) throws IOException {
            if (this.ph.getStatus() == 2 && n >= 0 && n < this.ptrs.length) {
                return BTree.this.getBTreeNode(this.root, this.ptrs[n], this);
            }
            return null;
        }

        public void getChildStream(int n, Streamable streamable) throws IOException {
            if (this.ph.getStatus() == 1 && n >= 0 && n < this.ptrs.length) {
                Value value = BTree.this.readValue(this.ptrs[n]);
                DataInputStream dataInputStream = new DataInputStream(value.getInputStream());
                streamable.read(dataInputStream);
            }
        }

        public long removeValue(Value value) throws IOException, BTreeException {
            int n = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    if (n < 0) {
                        n = -(n + 1);
                    }
                    return this.getChildNode(n).removeValue(value);
                }
                case 1: {
                    if (n < 0) {
                        throw new BTreeNotFoundException("Value '" + value.toString() + "' doesn't exist");
                    }
                    long l = this.ptrs[n];
                    this.setValues(Paged.deleteArrayValue(this.values, n));
                    this.setPointers(Paged.deleteArrayLong(this.ptrs, n));
                    this.write();
                    return l;
                }
            }
            throw new BTreeCorruptException("Invalid Page Type In removeValue");
        }

        public long addValue(Value value, long l) throws IOException, BTreeException {
            int n = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    if (n < 0) {
                        n = -(n + 1);
                    }
                    return this.getChildNode(n).addValue(value, l);
                }
                case 1: {
                    if (n >= 0) {
                        long l2 = this.ptrs[n];
                        this.ptrs[n] = l;
                        this.setValues(this.values);
                        this.setPointers(this.ptrs);
                        this.write();
                        return l2;
                    }
                    n = -(n + 1);
                    boolean bl = this.ph.getDataLen() + 6 + value.getLength() > BTree.this.fileHeader.getWorkSize();
                    this.setValues(Paged.insertArrayValue(this.values, value, n));
                    this.setPointers(Paged.insertArrayLong(this.ptrs, l, n));
                    if (bl) {
                        this.split();
                    } else {
                        this.write();
                    }
                    return -1L;
                }
            }
            throw new BTreeCorruptException("Invalid Page Type In addValue");
        }

        public void promoteValue(Value value, long l) throws IOException, BTreeException {
            boolean bl = this.ph.getDataLen() + 6 + value.getLength() > BTree.this.fileHeader.getWorkSize();
            int n = Arrays.binarySearch(this.values, value);
            if (n < 0) {
                n = -(n + 1);
            }
            this.setValues(Paged.insertArrayValue(this.values, value, n));
            this.setPointers(Paged.insertArrayLong(this.ptrs, l, n + 1));
            if (bl) {
                this.split();
            } else {
                this.write();
            }
        }

        public Value getSeparator(Value value, Value value2) {
            int n = value.compareTo(value2);
            byte[] byArray = new byte[Math.abs(n)];
            System.arraycopy(value2.getData(), 0, byArray, 0, byArray.length);
            return new Value(byArray);
        }

        public void split() throws IOException, BTreeException {
            Value value;
            long[] lArray;
            Value[] valueArray;
            long[] lArray2;
            Value[] valueArray2;
            short s = this.ph.getValueCount();
            int n = s / 2;
            switch (this.ph.getStatus()) {
                case 2: {
                    valueArray2 = new Value[n];
                    lArray2 = new long[valueArray2.length + 1];
                    valueArray = new Value[s - (n + 1)];
                    lArray = new long[valueArray.length + 1];
                    System.arraycopy(this.values, 0, valueArray2, 0, valueArray2.length);
                    System.arraycopy(this.ptrs, 0, lArray2, 0, lArray2.length);
                    System.arraycopy(this.values, valueArray2.length + 1, valueArray, 0, valueArray.length);
                    System.arraycopy(this.ptrs, lArray2.length, lArray, 0, lArray.length);
                    value = this.values[valueArray2.length];
                    break;
                }
                case 1: {
                    valueArray2 = new Value[n];
                    lArray2 = new long[valueArray2.length];
                    valueArray = new Value[s - n];
                    lArray = new long[valueArray.length];
                    System.arraycopy(this.values, 0, valueArray2, 0, valueArray2.length);
                    System.arraycopy(this.ptrs, 0, lArray2, 0, lArray2.length);
                    System.arraycopy(this.values, valueArray2.length, valueArray, 0, valueArray.length);
                    System.arraycopy(this.ptrs, lArray2.length, lArray, 0, lArray.length);
                    value = this.getSeparator(valueArray2[valueArray2.length - 1], valueArray[0]);
                    break;
                }
                default: {
                    throw new BTreeCorruptException("Invalid Page Type In split");
                }
            }
            this.setValues(valueArray2);
            this.setPointers(lArray2);
            if (this.parent == null) {
                BTreeNode bTreeNode = BTree.this.createBTreeNode(this.root, (byte)2, null);
                BTreeNode bTreeNode2 = BTree.this.createBTreeNode(this.root, this.ph.getStatus(), bTreeNode);
                bTreeNode2.setValues(valueArray);
                bTreeNode2.setPointers(lArray);
                bTreeNode.setValues(new Value[]{value});
                bTreeNode.setPointers(new long[]{this.page.getPageNum(), bTreeNode2.page.getPageNum()});
                this.parent = bTreeNode;
                BTree.this.setRootNode(this.root, bTreeNode);
                this.write();
                bTreeNode2.write();
                bTreeNode.write();
            } else {
                BTreeNode bTreeNode = BTree.this.createBTreeNode(this.root, this.ph.getStatus(), this.parent);
                bTreeNode.setValues(valueArray);
                bTreeNode.setPointers(lArray);
                this.write();
                bTreeNode.write();
                this.parent.promoteValue(value, bTreeNode.page.getPageNum());
            }
        }

        public long findValue(Value value) throws IOException, BTreeException {
            int n = Arrays.binarySearch(this.values, value);
            switch (this.ph.getStatus()) {
                case 2: {
                    if (n < 0) {
                        n = -(n + 1);
                    }
                    return this.getChildNode(n).findValue(value);
                }
                case 1: {
                    if (n < 0) {
                        throw new BTreeNotFoundException("Value '" + value.toString() + "' doesn't exist");
                    }
                    return this.ptrs[n];
                }
            }
            throw new BTreeCorruptException("Invalid Page Type In findValue");
        }

        public void query(IndexQuery indexQuery, BTreeCallback bTreeCallback) throws IOException, BTreeException {
            block55: {
                block54: {
                    if (indexQuery == null || indexQuery.getOperator() == 0) break block54;
                    Value[] valueArray = indexQuery.getValues();
                    int n = Arrays.binarySearch(this.values, valueArray[0]);
                    int n2 = valueArray.length > 1 ? Arrays.binarySearch(this.values, valueArray[valueArray.length - 1]) : n;
                    int n3 = indexQuery.getOperator();
                    boolean bl = n3 >= 0;
                    switch (this.ph.getStatus()) {
                        case 2: {
                            if (n < 0) {
                                n = -(n + 1);
                            }
                            if (n2 < 0) {
                                n2 = -(n2 + 1);
                            }
                            switch (indexQuery.getOperator()) {
                                case -7: 
                                case -6: 
                                case -5: 
                                case -4: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    int n4 = 0;
                                    while (n4 < this.ptrs.length) {
                                        if ((n4 >= n && n4 <= n2) == bl) {
                                            this.getChildNode(n4).query(indexQuery, bTreeCallback);
                                        }
                                        ++n4;
                                    }
                                    break block55;
                                }
                                case -1: 
                                case 1: {
                                    int n5 = 0;
                                    while (n5 < this.ptrs.length) {
                                        if (!bl || n5 == n) {
                                            this.getChildNode(n5).query(indexQuery, bTreeCallback);
                                        }
                                        ++n5;
                                    }
                                }
                                case -3: 
                                case 3: {
                                    int n6 = 0;
                                    while (n6 < this.ptrs.length) {
                                        if (n6 <= n == bl) {
                                            this.getChildNode(n6).query(indexQuery, bTreeCallback);
                                        }
                                        ++n6;
                                    }
                                    break block55;
                                }
                                case -2: 
                                case 2: {
                                    int n7 = 0;
                                    while (n7 < this.ptrs.length) {
                                        if (n7 >= n2 == bl) {
                                            this.getChildNode(n7).query(indexQuery, bTreeCallback);
                                        }
                                        ++n7;
                                    }
                                    break block55;
                                }
                                default: {
                                    int n8 = 0;
                                    while (n8 < this.ptrs.length) {
                                        this.getChildNode(n8).query(indexQuery, bTreeCallback);
                                        ++n8;
                                    }
                                    break block55;
                                }
                            }
                        }
                        case 1: {
                            switch (indexQuery.getOperator()) {
                                case 1: {
                                    if (n >= 0) {
                                        bTreeCallback.indexInfo(this.values[n], this.ptrs[n]);
                                        break;
                                    }
                                    break block55;
                                }
                                case -1: {
                                    int n9 = 0;
                                    while (n9 < this.ptrs.length) {
                                        if (n9 != n) {
                                            bTreeCallback.indexInfo(this.values[n9], this.ptrs[n9]);
                                        }
                                        ++n9;
                                    }
                                    break block55;
                                }
                                case -7: 
                                case -5: 
                                case -4: 
                                case 4: 
                                case 5: 
                                case 7: {
                                    if (n < 0) {
                                        n = -(n + 1);
                                    }
                                    if (n2 < 0) {
                                        n2 = -(n2 + 1);
                                    }
                                    int n10 = 0;
                                    while (n10 < this.ptrs.length) {
                                        if ((bl && n10 >= n && n10 <= n2 || !bl && (n10 <= n || n10 >= n2)) && indexQuery.testValue(this.values[n10])) {
                                            bTreeCallback.indexInfo(this.values[n10], this.ptrs[n10]);
                                        }
                                        ++n10;
                                    }
                                    break block55;
                                }
                                case -6: 
                                case 6: {
                                    if (n < 0) {
                                        n = -(n + 1);
                                    }
                                    if (n2 < 0) {
                                        n2 = -(n2 + 1);
                                    }
                                    int n11 = 0;
                                    while (n11 < this.ptrs.length) {
                                        if ((!bl || n11 >= n && n11 <= n2) && indexQuery.testValue(this.values[n11])) {
                                            bTreeCallback.indexInfo(this.values[n11], this.ptrs[n11]);
                                        }
                                        ++n11;
                                    }
                                    break block55;
                                }
                                case -3: 
                                case 3: {
                                    if (n < 0) {
                                        n = -(n + 1);
                                    }
                                    int n12 = 0;
                                    while (n12 < this.ptrs.length) {
                                        if ((bl && n12 <= n || !bl && n12 >= n) && indexQuery.testValue(this.values[n12])) {
                                            bTreeCallback.indexInfo(this.values[n12], this.ptrs[n12]);
                                        }
                                        ++n12;
                                    }
                                    break block55;
                                }
                                case -2: 
                                case 2: {
                                    if (n < 0) {
                                        n = -(n + 1);
                                    }
                                    int n13 = 0;
                                    while (n13 < this.ptrs.length) {
                                        if ((bl && n13 >= n || !bl && n13 <= n) && indexQuery.testValue(this.values[n13])) {
                                            bTreeCallback.indexInfo(this.values[n13], this.ptrs[n13]);
                                        }
                                        ++n13;
                                    }
                                    break block55;
                                }
                                default: {
                                    int n14 = 0;
                                    while (n14 < this.ptrs.length) {
                                        if (indexQuery.testValue(this.values[n14])) {
                                            bTreeCallback.indexInfo(this.values[n14], this.ptrs[n14]);
                                        }
                                        ++n14;
                                    }
                                    break block55;
                                }
                            }
                            break block55;
                        }
                        default: {
                            throw new BTreeCorruptException("Invalid Page Type In query");
                        }
                    }
                }
                switch (this.ph.getStatus()) {
                    case 2: {
                        int n = 0;
                        while (n < this.ptrs.length) {
                            this.getChildNode(n).query(indexQuery, bTreeCallback);
                            ++n;
                        }
                        break;
                    }
                    case 1: {
                        int n = 0;
                        while (n < this.values.length) {
                            bTreeCallback.indexInfo(this.values[n], this.ptrs[n]);
                            ++n;
                        }
                        break;
                    }
                    default: {
                        throw new BTreeCorruptException("Invalid Page Type In query");
                    }
                }
            }
        }
    }

    public final class BTreeRootInfo {
        private BTreeRootInfo parent;
        private Value name;
        private long page;

        public BTreeRootInfo(BTreeRootInfo bTreeRootInfo, String string, long l) {
            this.parent = bTreeRootInfo;
            this.name = new Value(string);
            this.page = l;
        }

        public BTreeRootInfo(BTreeRootInfo bTreeRootInfo, Value value, long l) {
            this.parent = bTreeRootInfo;
            this.name = value;
            this.page = l;
        }

        public BTreeRootInfo(String string, long l) {
            this.parent = BTree.this.rootInfo;
            this.name = new Value(string);
            this.page = l;
        }

        public BTreeRootInfo(Value value, long l) {
            this.parent = BTree.this.rootInfo;
            this.name = value;
            this.page = l;
        }

        private BTreeRootInfo(long l) {
            this.parent = null;
            this.name = null;
            this.page = l;
        }

        public BTreeRootInfo getParent() {
            return this.parent;
        }

        public Value getName() {
            return this.name;
        }

        public long getPage() {
            return this.page;
        }

        public void setPage(long l) {
            this.page = l;
        }
    }
}

