/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.filer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.Record;
import org.dbxml.core.data.RecordSet;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTree;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.BTreeException;
import org.dbxml.core.filer.BTreeNotFoundException;
import org.dbxml.core.filer.Filer;
import org.dbxml.core.filer.FilerException;
import org.dbxml.core.filer.Paged;
import org.dbxml.server.Configurable;
import org.dbxml.server.Configuration;

public final class BTreeFiler
extends BTree
implements Configurable,
Filer {
    protected static final byte RECORD = 20;
    private static final String PAGESIZE = "pagesize";
    private static final String MAXKEYSIZE = "maxkeysize";
    private Collection collection;
    private Configuration config;
    private BTreeFilerHeader fileHeader = (BTreeFilerHeader)this.getFileHeader();

    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setLocation(String string) {
        this.setFile(new File(this.collection.getCollectionRoot(), string + ".tbl"));
    }

    public String getName() {
        return "BTreeFiler";
    }

    public boolean open() throws DBException {
        if (super.open()) {
            this.fileHeader.setMaxKeySize(this.config.getShortAttribute(MAXKEYSIZE, this.fileHeader.getMaxKeySize()));
            return true;
        }
        return false;
    }

    public boolean create() throws DBException {
        this.fileHeader.setPageSize(this.config.getIntAttribute(PAGESIZE, this.fileHeader.getPageSize()));
        this.fileHeader.setMaxKeySize(this.config.getShortAttribute(MAXKEYSIZE, this.fileHeader.getMaxKeySize()));
        return super.create();
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
        this.setLocation(collection.getName());
    }

    public synchronized Record readRecord(Key key) throws DBException {
        this.checkOpened();
        try {
            long l = this.findValue(key);
            Paged.Page page = this.getPage(l);
            Value value = this.readValue(page);
            BTreeFilerPageHeader bTreeFilerPageHeader = (BTreeFilerPageHeader)page.getPageHeader();
            HashMap<String, Long> hashMap = new HashMap<String, Long>(2);
            hashMap.put("created", new Long(bTreeFilerPageHeader.getCreated()));
            hashMap.put("modified", new Long(bTreeFilerPageHeader.getModified()));
            return new Record(key, value, hashMap);
        }
        catch (BTreeNotFoundException bTreeNotFoundException) {
        }
        catch (BTreeException bTreeException) {
            throw bTreeException;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public synchronized boolean writeRecord(Key key, Value value) throws DBException {
        this.checkOpened();
        try {
            Paged.Page page;
            try {
                long l = this.findValue(key);
                page = this.getPage(l);
            }
            catch (BTreeNotFoundException bTreeNotFoundException) {
                page = this.getFreePage();
                this.addValue(key, page.getPageNum());
                this.fileHeader.incRecordCount();
            }
            BTreeFilerPageHeader bTreeFilerPageHeader = (BTreeFilerPageHeader)page.getPageHeader();
            long l = System.currentTimeMillis();
            if (bTreeFilerPageHeader.getStatus() == 0) {
                bTreeFilerPageHeader.setCreated(l);
            }
            bTreeFilerPageHeader.setModified(l);
            bTreeFilerPageHeader.setStatus((byte)20);
            this.writeValue(page, value);
            this.fileHeader.write();
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        return true;
    }

    public synchronized boolean deleteRecord(Key key) throws DBException {
        this.checkOpened();
        try {
            long l = this.findValue(key);
            Paged.Page page = this.getPage(l);
            this.removeValue(key);
            this.unlinkPages(page.getPageNum());
            this.fileHeader.decRecordCount();
            this.fileHeader.write();
            return true;
        }
        catch (BTreeNotFoundException bTreeNotFoundException) {
        }
        catch (BTreeException bTreeException) {
            throw bTreeException;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        return false;
    }

    public synchronized long getRecordCount() throws DBException {
        this.checkOpened();
        return this.fileHeader.getRecordCount();
    }

    public synchronized RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new BTreeFilerRecordSet();
    }

    public Paged.FileHeader createFileHeader() {
        return new BTreeFilerHeader();
    }

    public Paged.FileHeader createFileHeader(boolean bl) throws IOException {
        return new BTreeFilerHeader(bl);
    }

    public Paged.FileHeader createFileHeader(long l) {
        return new BTreeFilerHeader(l);
    }

    public Paged.FileHeader createFileHeader(long l, int n) {
        return new BTreeFilerHeader(l, n);
    }

    public Paged.PageHeader createPageHeader() {
        return new BTreeFilerPageHeader();
    }

    private final class BTreeFilerPageHeader
    extends BTree.BTreePageHeader {
        private long created = 0L;
        private long modified = 0L;

        public BTreeFilerPageHeader() {
        }

        public BTreeFilerPageHeader(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            super.read(dataInputStream);
            if (this.getStatus() == 0) {
                return;
            }
            this.created = dataInputStream.readLong();
            this.modified = dataInputStream.readLong();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeLong(this.created);
            dataOutputStream.writeLong(this.modified);
        }

        public void setRecordLen(int n) {
            BTreeFilerHeader bTreeFilerHeader = BTreeFiler.this.fileHeader;
            synchronized (bTreeFilerHeader) {
                BTreeFiler.this.fileHeader.setTotalBytes(BTreeFiler.this.fileHeader.totalBytes - (long)this.getRecordLen() + (long)n);
            }
            super.setRecordLen(n);
        }

        public void setCreated(long l) {
            this.created = l;
            this.setDirty();
        }

        public long getCreated() {
            return this.created;
        }

        public void setModified(long l) {
            this.modified = l;
            this.setDirty();
        }

        public long getModified() {
            return this.modified;
        }
    }

    private final class BTreeFilerHeader
    extends BTree.BTreeFileHeader {
        private long totalBytes = 0L;

        public BTreeFilerHeader() {
        }

        public BTreeFilerHeader(long l) {
            super(l);
        }

        public BTreeFilerHeader(long l, int n) {
            super(l, n);
        }

        public BTreeFilerHeader(boolean bl) throws IOException {
            super(bl);
        }

        public void read(RandomAccessFile randomAccessFile) throws IOException {
            super.read(randomAccessFile);
            this.totalBytes = randomAccessFile.readLong();
        }

        public void write(RandomAccessFile randomAccessFile) throws IOException {
            super.write(randomAccessFile);
            randomAccessFile.writeLong(this.totalBytes);
        }

        public void setTotalBytes(long l) {
            this.totalBytes = l;
            this.setDirty();
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BTreeFilerRecordSet
    implements RecordSet,
    BTreeCallback {
        private List keys = new ArrayList();
        private Iterator enum;

        public BTreeFilerRecordSet() throws DBException {
            try {
                BTreeFiler.this.query(null, this);
                this.enum = this.keys.iterator();
            }
            catch (IOException iOException) {
                throw new FilerException(70, "Error generating RecordSet");
            }
        }

        public boolean indexInfo(Value value, long l) {
            this.keys.add(new Key(value));
            return true;
        }

        public Key getNextKey() {
            return (Key)this.enum.next();
        }

        public Record getNextRecord() throws DBException {
            return BTreeFiler.this.readRecord((Key)this.enum.next());
        }

        public Value getNextValue() throws DBException {
            return this.getNextRecord().getValue();
        }

        public boolean hasMoreRecords() {
            return this.enum.hasNext();
        }
    }
}

