/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.filer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.Record;
import org.dbxml.core.data.RecordSet;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.Filer;
import org.dbxml.core.filer.FilerException;
import org.dbxml.server.Configuration;
import org.dbxml.server.SimpleConfigurable;
import org.dbxml.server.dbXMLException;
import org.dbxml.server.util.FileCache;
import org.dbxml.server.util.LockManager;

public final class FSFiler
extends SimpleConfigurable
implements Filer {
    private static final String LOCATION = "location";
    private static final String EXT = "ext";
    private static final String READONLY = "readonly";
    private FileCache cache = new FileCache();
    private LockManager locks = new LockManager(16);
    private Set extensions = null;
    private String location;
    private Collection collection;
    private File dir;
    private boolean opened = false;
    private boolean readOnly = false;

    public String getName() {
        return "FSFiler";
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public void setConfig(Configuration configuration) throws dbXMLException {
        super.setConfig(configuration);
        this.location = configuration.getAttribute(LOCATION);
        this.readOnly = configuration.getBooleanAttribute(READONLY, this.readOnly);
        String string = configuration.getAttribute(EXT);
        if (string != null && string.trim().length() > 0) {
            this.extensions = new HashSet();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                this.extensions.add(stringTokenizer.nextToken());
            }
        }
        this.dir = new File(this.location);
        this.opened = false;
    }

    private void checkOpened() throws DBException {
        if (!this.opened) {
            throw new FilerException(247, "Filer is closed");
        }
    }

    private void checkReadOnly() throws DBException {
        if (this.readOnly) {
            throw new FilerException(246, "Filer is read-only");
        }
    }

    public boolean close() {
        this.opened = false;
        return true;
    }

    public boolean open() {
        this.opened = this.dir.exists() && this.dir.isDirectory();
        return this.opened;
    }

    public boolean drop() {
        this.opened = false;
        return true;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean exists() {
        return this.dir.exists();
    }

    public boolean create() {
        if (!this.dir.exists()) {
            return this.dir.mkdirs();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Record readRecord(Key key) throws DBException {
        File file;
        block6: {
            Record record;
            this.checkOpened();
            String string = key.toString();
            if (!this.isExtensionValid(string)) {
                return null;
            }
            file = new File(this.dir, string);
            try {
                try {
                    this.locks.acquireSharedLock((Object)file);
                    HashMap<String, Long> hashMap = new HashMap<String, Long>(1);
                    hashMap.put("modified", new Long(file.lastModified()));
                    byte[] byArray = this.cache.getFile(file);
                    if (byArray == null) break block6;
                    record = new Record(key, new Value(byArray), hashMap);
                    Object var8_8 = null;
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                    Object var8_10 = null;
                    this.locks.releaseSharedLock((Object)file);
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.locks.releaseSharedLock((Object)file);
                throw throwable;
            }
            this.locks.releaseSharedLock((Object)file);
            return record;
        }
        Object var8_9 = null;
        this.locks.releaseSharedLock((Object)file);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeRecord(Key key, Value value) throws DBException {
        boolean bl;
        this.checkOpened();
        this.checkReadOnly();
        String string = key.toString();
        if (!this.isExtensionValid(string)) {
            return false;
        }
        File file = new File(this.dir, string);
        try {
            try {
                this.locks.acquireExclusiveLock((Object)file);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                value.streamTo(fileOutputStream);
                fileOutputStream.close();
                bl = true;
                Object var8_8 = null;
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
                Object var8_9 = null;
                this.locks.releaseExclusiveLock((Object)file);
                return true;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.locks.releaseExclusiveLock((Object)file);
            throw throwable;
        }
        this.locks.releaseExclusiveLock((Object)file);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteRecord(Key key) throws DBException {
        boolean bl;
        this.checkOpened();
        this.checkReadOnly();
        String string = key.toString();
        if (!this.isExtensionValid(string)) {
            return false;
        }
        File file = new File(this.dir, string);
        try {
            try {
                this.locks.acquireExclusiveLock((Object)file);
                bl = file.delete();
                Object var6_6 = null;
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
                Object var6_7 = null;
                this.locks.releaseExclusiveLock((Object)file);
                return true;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.locks.releaseExclusiveLock((Object)file);
            throw throwable;
        }
        this.locks.releaseExclusiveLock((Object)file);
        return bl;
    }

    public long getRecordCount() throws DBException {
        this.checkOpened();
        File[] fileArray = this.dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && FSFiler.this.isExtensionValid(file.getName());
            }
        });
        return fileArray.length;
    }

    public RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new FSRecordSet();
    }

    private boolean isExtensionValid(String string) {
        if (this.extensions != null) {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(n + 1);
            if (!this.extensions.contains(string2)) {
                return false;
            }
        }
        return true;
    }

    private class FSRecordSet
    implements RecordSet {
        public File[] files;
        public int pos = 0;

        public FSRecordSet() {
            this.files = FSFiler.this.dir.listFiles(new FileFilter(this){
                private final /* synthetic */ FSRecordSet this$1;
                {
                    this.this$1 = fSRecordSet;
                }

                public boolean accept(File file) {
                    return file.isFile() && FSFiler.access$000(FSRecordSet.access$100(this.this$1), file.getName());
                }
            });
        }

        public boolean hasMoreRecords() {
            return this.pos < this.files.length;
        }

        public Record getNextRecord() throws DBException {
            File file = this.files[this.pos++];
            return FSFiler.this.readRecord(new Key(file.getName()));
        }

        public Value getNextValue() throws DBException {
            return this.getNextRecord().getValue();
        }

        public Key getNextKey() {
            return new Key(this.files[this.pos++].getName());
        }

        static /* synthetic */ FSFiler access$100(FSRecordSet fSRecordSet) {
            return fSRecordSet.FSFiler.this;
        }
    }
}

