/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.filer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.Record;
import org.dbxml.core.data.RecordSet;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTree;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.Filer;
import org.dbxml.core.filer.Paged;
import org.dbxml.server.Configurable;
import org.dbxml.server.Configuration;

public final class HashFiler
extends Paged
implements Configurable,
Filer {
    protected static final byte RECORD = 1;
    private static final String PAGECOUNT = "pagecount";
    private static final String PAGESIZE = "pagesize";
    private static final String MAXKEYSIZE = "maxkeysize";
    private Collection collection;
    private Configuration config;
    private HashFileHeader fileHeader = (HashFileHeader)this.getFileHeader();
    private BTree btree;

    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setLocation(String string) {
        this.setFile(new File(this.collection.getCollectionRoot(), string + ".tbl"));
        this.btree = new BTree(new File(this.collection.getCollectionRoot(), string + ".pkx"));
    }

    public String getName() {
        return "HashFiler";
    }

    public boolean open() throws DBException {
        if (super.open()) {
            this.fileHeader.setMaxKeySize(this.config.getShortAttribute(MAXKEYSIZE, this.fileHeader.getMaxKeySize()));
            this.btree.open();
            return true;
        }
        return false;
    }

    public boolean create() throws DBException {
        this.fileHeader.setPageCount(this.config.getLongAttribute(PAGECOUNT, this.fileHeader.getPageCount()));
        this.fileHeader.setPageSize(this.config.getIntAttribute(PAGESIZE, this.fileHeader.getPageSize()));
        this.fileHeader.setMaxKeySize(this.config.getShortAttribute(MAXKEYSIZE, this.fileHeader.getMaxKeySize()));
        this.btree.create();
        return super.create();
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
        this.setLocation(collection.getName());
    }

    private Paged.Page seekRecordPage(Key key) throws IOException {
        int n = key.getHash();
        long l = (long)n % this.fileHeader.getPageCount();
        Paged.Page page = null;
        HashPageHeader hashPageHeader = null;
        do {
            if ((hashPageHeader = (HashPageHeader)(page = this.getPage(l)).getPageHeader()).getStatus() != 1 || hashPageHeader.getKeyHash() != key.getHash() || !page.getKey().equals(key)) continue;
            return page;
        } while ((l = hashPageHeader.getNextCollision()) != -1L);
        return null;
    }

    private Paged.Page seekInsertionPage(Key key) throws IOException {
        int n = key.getHash();
        long l = (long)n % this.fileHeader.getPageCount();
        Paged.Page page = null;
        HashPageHeader hashPageHeader = null;
        do {
            if ((hashPageHeader = (HashPageHeader)(page = this.getPage(l)).getPageHeader()).getStatus() != 0 && hashPageHeader.getStatus() != 127 && (hashPageHeader.getStatus() != 1 || hashPageHeader.getKeyHash() != key.getHash() || !page.getKey().equals(key))) continue;
            return page;
        } while ((l = hashPageHeader.getNextCollision()) != -1L);
        Paged.Page page2 = this.getFreePage();
        hashPageHeader.setNextCollision(page2.getPageNum());
        page.write();
        return page2;
    }

    public synchronized Record readRecord(Key key) throws DBException {
        this.checkOpened();
        try {
            Paged.Page page = this.seekRecordPage(key);
            if (page != null) {
                Value value = this.readValue(page);
                HashPageHeader hashPageHeader = (HashPageHeader)page.getPageHeader();
                HashMap<String, Long> hashMap = new HashMap<String, Long>(2);
                hashMap.put("created", new Long(hashPageHeader.getCreated()));
                hashMap.put("modified", new Long(hashPageHeader.getModified()));
                return new Record(key, value, hashMap);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    public synchronized boolean writeRecord(Key key, Value value) throws DBException {
        this.checkOpened();
        try {
            Paged.Page page = this.seekInsertionPage(key);
            HashPageHeader hashPageHeader = (HashPageHeader)page.getPageHeader();
            long l = System.currentTimeMillis();
            if (hashPageHeader.getStatus() == 0) {
                this.fileHeader.incRecordCount();
                this.btree.addValue(key, page.getPageNum());
                hashPageHeader.setCreated(l);
            }
            hashPageHeader.setModified(l);
            hashPageHeader.setStatus((byte)1);
            page.setKey(key);
            this.writeValue(page, value);
            this.fileHeader.write();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        return true;
    }

    public synchronized boolean deleteRecord(Key key) throws DBException {
        this.checkOpened();
        try {
            int n = key.getHash();
            long l = (long)n % this.fileHeader.getPageCount();
            Paged.Page page = null;
            Paged.Page page2 = null;
            HashPageHeader hashPageHeader = null;
            HashPageHeader hashPageHeader2 = null;
            while ((hashPageHeader2 = (HashPageHeader)(page2 = this.getPage(l)).getPageHeader()).getStatus() != 1 || hashPageHeader2.getKeyHash() != key.getHash() || !page2.getKey().equals(key)) {
                l = hashPageHeader2.getNextCollision();
                if (l == -1L) {
                    return false;
                }
                page = page2;
                hashPageHeader = hashPageHeader2;
            }
            if (page2 == null) {
                return false;
            }
            if (page != null) {
                hashPageHeader.setNextCollision(hashPageHeader2.nextCollision);
                page.write();
            }
            this.btree.removeValue(key);
            this.unlinkPages(page2);
            this.fileHeader.decRecordCount();
            this.fileHeader.write();
            return true;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    public synchronized long getRecordCount() throws DBException {
        this.checkOpened();
        return this.fileHeader.getRecordCount();
    }

    public synchronized RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new HashFilerRecordSet();
    }

    public Paged.FileHeader createFileHeader() {
        return new HashFileHeader();
    }

    public Paged.FileHeader createFileHeader(boolean bl) throws IOException {
        return new HashFileHeader(bl);
    }

    public Paged.FileHeader createFileHeader(long l) {
        return new HashFileHeader(l);
    }

    public Paged.FileHeader createFileHeader(long l, int n) {
        return new HashFileHeader(l, n);
    }

    public Paged.PageHeader createPageHeader() {
        return new HashPageHeader();
    }

    private final class HashPageHeader
    extends Paged.PageHeader {
        private long created = 0L;
        private long modified = 0L;
        private long nextCollision = -1L;

        public HashPageHeader() {
        }

        public HashPageHeader(DataInputStream dataInputStream) throws IOException {
            super(dataInputStream);
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            super.read(dataInputStream);
            if (this.getStatus() == 0) {
                return;
            }
            this.created = dataInputStream.readLong();
            this.modified = dataInputStream.readLong();
            this.nextCollision = dataInputStream.readLong();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            super.write(dataOutputStream);
            dataOutputStream.writeLong(this.created);
            dataOutputStream.writeLong(this.modified);
            dataOutputStream.writeLong(this.nextCollision);
        }

        public void setRecordLen(int n) {
            HashFileHeader hashFileHeader = HashFiler.this.fileHeader;
            synchronized (hashFileHeader) {
                HashFiler.this.fileHeader.setTotalBytes(HashFiler.this.fileHeader.totalBytes - (long)this.getRecordLen() + (long)n);
            }
            super.setRecordLen(n);
        }

        public void setCreated(long l) {
            this.created = l;
            this.setDirty();
        }

        public long getCreated() {
            return this.created;
        }

        public void setModified(long l) {
            this.modified = l;
            this.setDirty();
        }

        public long getModified() {
            return this.modified;
        }

        public void setNextCollision(long l) {
            this.nextCollision = l;
            this.setDirty();
        }

        public long getNextCollision() {
            return this.nextCollision;
        }
    }

    private final class HashFileHeader
    extends Paged.FileHeader {
        private long totalBytes = 0L;

        public HashFileHeader() {
        }

        public HashFileHeader(long l) {
            super(l);
        }

        public HashFileHeader(long l, int n) {
            super(l, n);
        }

        public HashFileHeader(boolean bl) throws IOException {
            super(bl);
        }

        public void read(RandomAccessFile randomAccessFile) throws IOException {
            super.read(randomAccessFile);
            this.totalBytes = randomAccessFile.readLong();
        }

        public void write(RandomAccessFile randomAccessFile) throws IOException {
            super.write(randomAccessFile);
            randomAccessFile.writeLong(this.totalBytes);
        }

        public void setTotalBytes(long l) {
            this.totalBytes = l;
            this.setDirty();
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class HashFilerRecordSet
    implements RecordSet,
    BTreeCallback {
        private List keys = new ArrayList();
        private Iterator enum;

        public HashFilerRecordSet() {
            try {
                HashFiler.this.btree.query(null, this);
                this.enum = this.keys.iterator();
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }

        public boolean indexInfo(Value value, long l) {
            this.keys.add(new Key(value));
            return true;
        }

        public Key getNextKey() {
            return (Key)this.enum.next();
        }

        public Record getNextRecord() throws DBException {
            return HashFiler.this.readRecord((Key)this.enum.next());
        }

        public Value getNextValue() throws DBException {
            return this.getNextRecord().getValue();
        }

        public boolean hasMoreRecords() {
            return this.enum.hasNext();
        }
    }
}

