/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.filer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.Record;
import org.dbxml.core.data.RecordSet;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.Filer;
import org.dbxml.core.filer.FilerException;
import org.dbxml.server.SimpleConfigurable;

public final class MemFiler
extends SimpleConfigurable
implements Filer {
    private Map hashTable = null;
    private boolean opened = false;
    private boolean readOnly = false;
    private Collection collection;

    public MemFiler() {
        this.hashTable = Collections.synchronizedMap(new HashMap());
    }

    public MemFiler(Map map, boolean bl) {
        this.hashTable = map;
        this.readOnly = bl;
    }

    public MemFiler(Map map) {
        this(map, false);
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public String getName() {
        return "MemFiler";
    }

    private void checkOpened() throws DBException {
        if (!this.opened) {
            throw new FilerException(247, "Filer is closed");
        }
    }

    private void checkReadOnly() throws DBException {
        if (this.readOnly) {
            throw new FilerException(246, "Filer is read-only");
        }
    }

    public boolean create() {
        this.hashTable.clear();
        return true;
    }

    public boolean open() {
        this.opened = true;
        return this.opened;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean exists() {
        return true;
    }

    public boolean drop() {
        this.hashTable.clear();
        this.opened = false;
        return !this.opened;
    }

    public boolean close() {
        this.opened = false;
        return !this.opened;
    }

    public Record readRecord(Key key) throws DBException {
        this.checkOpened();
        return (Record)this.hashTable.get(key);
    }

    public boolean writeRecord(Key key, Value value) throws DBException {
        this.checkOpened();
        this.checkReadOnly();
        this.hashTable.put(key, new Record(key, value));
        return true;
    }

    public boolean deleteRecord(Key key) throws DBException {
        this.checkOpened();
        this.checkReadOnly();
        return this.hashTable.remove(key) != null;
    }

    public long getRecordCount() throws DBException {
        this.checkOpened();
        return this.hashTable.size();
    }

    public RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new MemRecordSet();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MemRecordSet
    implements RecordSet {
        private Iterator enum;

        private MemRecordSet() {
            this.enum = MemFiler.this.hashTable.values().iterator();
        }

        public boolean hasMoreRecords() throws DBException {
            return this.enum.hasNext();
        }

        public Record getNextRecord() throws DBException {
            MemFiler.this.checkOpened();
            return (Record)this.enum.next();
        }

        public Value getNextValue() throws DBException {
            MemFiler.this.checkOpened();
            return ((Record)this.enum.next()).getValue();
        }

        public Key getNextKey() {
            return ((Record)this.enum.next()).getKey();
        }
    }
}

