/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.filer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.WeakHashMap;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.FilerException;
import org.dbxml.core.filer.Streamable;

public abstract class Paged {
    protected static final byte UNUSED = 0;
    protected static final byte OVERFLOW = 126;
    protected static final byte DELETED = 127;
    private Map pages = new WeakHashMap();
    private File file;
    private RandomAccessFile raf;
    private boolean opened = false;
    private FileHeader fileHeader = this.createFileHeader();

    public Paged() {
    }

    public Paged(File file) {
        this();
        this.setFile(file);
    }

    protected final void setFile(File file) {
        this.file = file;
    }

    protected final File getFile() {
        return this.file;
    }

    protected final Page getPage(Long l) throws IOException {
        Page page = (Page)this.pages.get(l);
        if (page == null) {
            page = new Page(l);
            page.read();
            this.pages.put(l, page);
        }
        return page;
    }

    protected final Page getPage(long l) throws IOException {
        return this.getPage(new Long(l));
    }

    protected final Value readValue(Page page) throws IOException {
        PageHeader pageHeader = page.getPageHeader();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pageHeader.getRecordLen());
        Page page2 = page;
        PageHeader pageHeader2 = null;
        while (true) {
            pageHeader2 = page2.getPageHeader();
            page2.streamTo(byteArrayOutputStream);
            long l = pageHeader2.getNextPage();
            if (l == -1L) break;
            page2 = this.getPage(l);
        }
        return new Value(byteArrayOutputStream.toByteArray());
    }

    protected final Value readValue(long l) throws IOException {
        return this.readValue(this.getPage(l));
    }

    protected final void writeValue(Page page, Value value) throws IOException {
        InputStream inputStream = value.getInputStream();
        PageHeader pageHeader = page.getPageHeader();
        pageHeader.setRecordLen(value.getLength());
        page.streamFrom(inputStream);
        while (inputStream.available() > 0) {
            Page page2 = page;
            PageHeader pageHeader2 = pageHeader;
            long l = pageHeader2.getNextPage();
            if (l != -1L) {
                page = this.getPage(l);
            } else {
                page = this.getFreePage();
                pageHeader2.setNextPage(page.getPageNum());
            }
            pageHeader = page.getPageHeader();
            pageHeader.setStatus((byte)126);
            page.streamFrom(inputStream);
            page2.write();
        }
        long l = pageHeader.getNextPage();
        if (l != -1L) {
            this.unlinkPages(l);
        }
        pageHeader.setNextPage(-1L);
        page.write();
    }

    protected final void writeValue(long l, Value value) throws IOException {
        this.writeValue(this.getPage(l), value);
    }

    protected final void unlinkPages(Page page) throws IOException {
        long l;
        if (page.pageNum < this.fileHeader.pageCount) {
            l = page.header.nextPage;
            page.header.setStatus((byte)127);
            page.header.setNextPage(-1L);
            page.write();
            Page page2 = page = l != -1L ? this.getPage(l) : null;
        }
        if (page != null) {
            l = page.pageNum;
            while (page.header.nextPage != -1L) {
                page = this.getPage(page.header.nextPage);
            }
            long l2 = page.pageNum;
            if (this.fileHeader.lastFreePage != -1L) {
                Page page3 = this.getPage(this.fileHeader.lastFreePage);
                page3.header.setNextPage(l);
                page3.write();
            }
            if (this.fileHeader.firstFreePage == -1L) {
                this.fileHeader.setFirstFreePage(l);
            }
            this.fileHeader.setLastFreePage(l2);
        }
    }

    protected final void unlinkPages(long l) throws IOException {
        this.unlinkPages(this.getPage(l));
    }

    protected final Page getFreePage() throws IOException {
        Page page = null;
        long l = this.fileHeader.firstFreePage;
        if (l != -1L) {
            page = this.getPage(l);
            this.fileHeader.setFirstFreePage(page.getPageHeader().nextPage);
            if (this.fileHeader.firstFreePage == -1L) {
                this.fileHeader.setLastFreePage(-1L);
            }
        } else {
            l = this.fileHeader.totalCount;
            this.fileHeader.setTotalCount(l + 1L);
            page = this.getPage(l);
        }
        page.header.setNextPage(-1L);
        page.header.setStatus((byte)0);
        return page;
    }

    protected final void checkOpened() throws DBException {
        if (!this.opened) {
            throw new FilerException(247, "Filer is closed");
        }
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean create() throws DBException {
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
            this.fileHeader.write();
            return true;
        }
        catch (Exception exception) {
            throw new FilerException(70, "Error creating " + this.file.getName());
        }
    }

    public boolean open() throws DBException {
        try {
            if (this.exists()) {
                this.raf = new RandomAccessFile(this.file, "rw");
                this.fileHeader.read();
                this.opened = true;
            } else {
                this.opened = false;
            }
            return this.opened;
        }
        catch (Exception exception) {
            throw new FilerException(70, "Error opening " + this.file.getName());
        }
    }

    public boolean close() throws DBException {
        try {
            this.opened = false;
            this.raf.close();
            return true;
        }
        catch (Exception exception) {
            throw new FilerException(70, "Error closing " + this.file.getName());
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean drop() throws DBException {
        try {
            this.close();
            if (this.exists()) {
                return this.getFile().delete();
            }
            return true;
        }
        catch (Exception exception) {
            throw new FilerException(271, "Can't drop Filer");
        }
    }

    public abstract FileHeader createFileHeader();

    public abstract FileHeader createFileHeader(boolean var1) throws IOException;

    public abstract FileHeader createFileHeader(long var1);

    public abstract FileHeader createFileHeader(long var1, int var3);

    public abstract PageHeader createPageHeader();

    public static Value[] insertArrayValue(Value[] valueArray, Value value, int n) {
        Value[] valueArray2 = new Value[valueArray.length + 1];
        if (n > 0) {
            System.arraycopy(valueArray, 0, valueArray2, 0, n);
        }
        valueArray2[n] = value;
        if (n < valueArray.length) {
            System.arraycopy(valueArray, n, valueArray2, n + 1, valueArray.length - n);
        }
        return valueArray2;
    }

    public static Value[] deleteArrayValue(Value[] valueArray, int n) {
        Value[] valueArray2 = new Value[valueArray.length - 1];
        if (n > 0) {
            System.arraycopy(valueArray, 0, valueArray2, 0, n);
        }
        if (n < valueArray2.length) {
            System.arraycopy(valueArray, n + 1, valueArray2, n, valueArray2.length - n);
        }
        return valueArray2;
    }

    public static long[] insertArrayLong(long[] lArray, long l, int n) {
        long[] lArray2 = new long[lArray.length + 1];
        if (n > 0) {
            System.arraycopy(lArray, 0, lArray2, 0, n);
        }
        lArray2[n] = l;
        if (n < lArray.length) {
            System.arraycopy(lArray, n, lArray2, n + 1, lArray.length - n);
        }
        return lArray2;
    }

    public static long[] deleteArrayLong(long[] lArray, int n) {
        long[] lArray2 = new long[lArray.length - 1];
        if (n > 0) {
            System.arraycopy(lArray, 0, lArray2, 0, n);
        }
        if (n < lArray2.length) {
            System.arraycopy(lArray, n + 1, lArray2, n, lArray2.length - n);
        }
        return lArray2;
    }

    public static int[] insertArrayInt(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[nArray.length + 1];
        if (n2 > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        nArray2[n2] = n;
        if (n2 < nArray.length) {
            System.arraycopy(nArray, n2, nArray2, n2 + 1, nArray.length - n2);
        }
        return nArray2;
    }

    public static int[] deleteArrayInt(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length - 1];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n < nArray2.length) {
            System.arraycopy(nArray, n + 1, nArray2, n, nArray2.length - n);
        }
        return nArray2;
    }

    public static short[] insertArrayShort(short[] sArray, short s, int n) {
        short[] sArray2 = new short[sArray.length + 1];
        if (n > 0) {
            System.arraycopy(sArray, 0, sArray2, 0, n);
        }
        sArray2[n] = s;
        if (n < sArray.length) {
            System.arraycopy(sArray, n, sArray2, n + 1, sArray.length - n);
        }
        return sArray2;
    }

    public static short[] deleteArrayShort(short[] sArray, int n) {
        short[] sArray2 = new short[sArray.length - 1];
        if (n > 0) {
            System.arraycopy(sArray, 0, sArray2, 0, n);
        }
        if (n < sArray2.length) {
            System.arraycopy(sArray, n + 1, sArray2, n, sArray2.length - n);
        }
        return sArray2;
    }

    public final class Page
    implements Comparable {
        private long pageNum;
        private byte[] data;
        private PageHeader header;
        private int keyPos;
        private int dataPos;
        private long offset;

        public Page() {
            this.header = Paged.this.createPageHeader();
        }

        public Page(long l) throws IOException {
            this();
            this.setPageNum(l);
        }

        public void read() throws IOException {
            Object var1_1 = null;
            this.data = new byte[Paged.this.fileHeader.pageSize];
            Paged.this.raf.seek(this.offset);
            Paged.this.raf.read(this.data);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.header.read(dataInputStream);
            this.keyPos = Paged.this.fileHeader.pageHeaderSize;
            this.dataPos = this.keyPos + this.header.keyLen;
        }

        public void write() throws IOException {
            if (!this.header.dirty) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Paged.this.fileHeader.getPageHeaderSize());
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.header.write(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            System.arraycopy(byArray, 0, this.data, 0, byArray.length);
            if (this.offset >= Paged.this.raf.length()) {
                long l = (long)Paged.this.fileHeader.headerSize + Paged.this.fileHeader.totalCount * 3L / 2L * (long)Paged.this.fileHeader.pageSize + (long)(Paged.this.fileHeader.pageSize - 1);
                Paged.this.raf.seek(l);
                Paged.this.raf.writeByte(0);
            }
            Paged.this.raf.seek(this.offset);
            Paged.this.raf.write(this.data);
        }

        public void setPageNum(long l) {
            this.pageNum = l;
            this.offset = (long)Paged.this.fileHeader.headerSize + l * (long)Paged.this.fileHeader.pageSize;
        }

        public long getPageNum() {
            return this.pageNum;
        }

        public PageHeader getPageHeader() {
            return this.header;
        }

        public void setKey(Key key) {
            this.header.setKey(key);
            key.copyTo(this.data, this.keyPos);
        }

        public Key getKey() {
            if (this.header.keyLen > 0) {
                return new Key(this.data, this.keyPos, this.header.keyLen);
            }
            return null;
        }

        public void streamTo(OutputStream outputStream) throws IOException {
            if (this.header.dataLen > 0) {
                outputStream.write(this.data, this.dataPos, this.header.dataLen);
            }
        }

        public void streamFrom(InputStream inputStream) throws IOException {
            int n = inputStream.available();
            this.header.dataLen = Paged.this.fileHeader.workSize - this.header.keyLen;
            if (n < this.header.dataLen) {
                this.header.dataLen = n;
            }
            if (this.header.dataLen > 0) {
                inputStream.read(this.data, this.keyPos + this.header.keyLen, this.header.dataLen);
            }
        }

        public int compareTo(Object object) {
            return (int)(this.pageNum - ((Page)object).pageNum);
        }
    }

    public abstract class PageHeader
    implements Streamable {
        private boolean dirty = false;
        private byte status = 0;
        private short keyLen = 0;
        private int keyHash = 0;
        private int dataLen = 0;
        private int recordLen = 0;
        private long nextPage = -1L;

        public PageHeader() {
        }

        public PageHeader(DataInputStream dataInputStream) throws IOException {
            this.read(dataInputStream);
        }

        public void read(DataInputStream dataInputStream) throws IOException {
            this.status = dataInputStream.readByte();
            this.dirty = false;
            if (this.status == 0) {
                return;
            }
            this.keyLen = dataInputStream.readShort();
            this.keyHash = dataInputStream.readInt();
            this.dataLen = dataInputStream.readInt();
            this.recordLen = dataInputStream.readInt();
            this.nextPage = dataInputStream.readLong();
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            this.dirty = false;
            dataOutputStream.writeByte(this.status);
            dataOutputStream.writeShort(this.keyLen);
            dataOutputStream.writeInt(this.keyHash);
            dataOutputStream.writeInt(this.dataLen);
            dataOutputStream.writeInt(this.recordLen);
            dataOutputStream.writeLong(this.nextPage);
        }

        public final boolean isDirty() {
            return this.dirty;
        }

        public final void setDirty() {
            this.dirty = true;
        }

        public final void setStatus(byte by) {
            this.status = by;
            this.dirty = true;
        }

        public final byte getStatus() {
            return this.status;
        }

        public final void setKey(Key key) {
            this.setRecordLen(0);
            this.dataLen = 0;
            this.keyHash = key.getHash();
            this.keyLen = (short)key.getLength();
            this.dirty = true;
        }

        public final void setKeyLen(short s) {
            this.keyLen = s;
            this.dirty = true;
        }

        public final short getKeyLen() {
            return this.keyLen;
        }

        public final void setKeyHash(int n) {
            this.keyHash = n;
            this.dirty = true;
        }

        public final int getKeyHash() {
            return this.keyHash;
        }

        public final void setDataLen(int n) {
            this.dataLen = n;
            this.dirty = true;
        }

        public final int getDataLen() {
            return this.dataLen;
        }

        public void setRecordLen(int n) {
            this.recordLen = n;
            this.dirty = true;
        }

        public final int getRecordLen() {
            return this.recordLen;
        }

        public final void setNextPage(long l) {
            this.nextPage = l;
            this.dirty = true;
        }

        public final long getNextPage() {
            return this.nextPage;
        }
    }

    public abstract class FileHeader {
        private boolean dirty = false;
        private int workSize;
        private short headerSize;
        private int pageSize;
        private long pageCount;
        private long totalCount;
        private long firstFreePage = -1L;
        private long lastFreePage = -1L;
        private byte pageHeaderSize = (byte)64;
        private short maxKeySize = (short)256;
        private long recordCount;

        public FileHeader() {
            this(1024L);
        }

        public FileHeader(long l) {
            this(l, 4096);
        }

        public FileHeader(long l, int n) {
            this.pageSize = n;
            this.pageCount = l;
            this.totalCount = l;
            this.headerSize = (short)4096;
            this.calculateWorkSize();
        }

        public FileHeader(boolean bl) throws IOException {
            if (bl) {
                this.read();
            }
        }

        public final void read() throws IOException {
            Paged.this.raf.seek(0L);
            this.read(Paged.this.raf);
            this.calculateWorkSize();
        }

        public void read(RandomAccessFile randomAccessFile) throws IOException {
            this.headerSize = randomAccessFile.readShort();
            this.pageSize = randomAccessFile.readInt();
            this.pageCount = randomAccessFile.readLong();
            this.totalCount = randomAccessFile.readLong();
            this.firstFreePage = randomAccessFile.readLong();
            this.lastFreePage = randomAccessFile.readLong();
            this.pageHeaderSize = randomAccessFile.readByte();
            this.maxKeySize = randomAccessFile.readShort();
            this.recordCount = randomAccessFile.readLong();
        }

        public final void write() throws IOException {
            if (!this.dirty) {
                return;
            }
            Paged.this.raf.seek(0L);
            this.write(Paged.this.raf);
            this.dirty = false;
        }

        public void write(RandomAccessFile randomAccessFile) throws IOException {
            randomAccessFile.writeShort(this.headerSize);
            randomAccessFile.writeInt(this.pageSize);
            randomAccessFile.writeLong(this.pageCount);
            randomAccessFile.writeLong(this.totalCount);
            randomAccessFile.writeLong(this.firstFreePage);
            randomAccessFile.writeLong(this.lastFreePage);
            randomAccessFile.writeByte(this.pageHeaderSize);
            randomAccessFile.writeShort(this.maxKeySize);
            randomAccessFile.writeLong(this.recordCount);
        }

        public final void setDirty() {
            this.dirty = true;
        }

        public final boolean isDirty() {
            return this.dirty;
        }

        public final void setHeaderSize(short s) {
            this.headerSize = s;
            this.dirty = true;
        }

        public final short getHeaderSize() {
            return this.headerSize;
        }

        public final void setPageSize(int n) {
            this.pageSize = n;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final int getPageSize() {
            return this.pageSize;
        }

        public final void setPageCount(long l) {
            this.pageCount = l;
            this.dirty = true;
        }

        public final long getPageCount() {
            return this.pageCount;
        }

        public final void setTotalCount(long l) {
            this.totalCount = l;
            this.dirty = true;
        }

        public final long getTotalCount() {
            return this.totalCount;
        }

        public final void setFirstFreePage(long l) {
            this.firstFreePage = l;
            this.dirty = true;
        }

        public final long getFirstFreePage() {
            return this.firstFreePage;
        }

        public final void setLastFreePage(long l) {
            this.lastFreePage = l;
            this.dirty = true;
        }

        public final long getLastFreePage() {
            return this.lastFreePage;
        }

        public final void setPageHeaderSize(byte by) {
            this.pageHeaderSize = by;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final byte getPageHeaderSize() {
            return this.pageHeaderSize;
        }

        public final void setMaxKeySize(short s) {
            this.maxKeySize = s;
            this.dirty = true;
        }

        public final short getMaxKeySize() {
            return this.maxKeySize;
        }

        public final void setRecordCount(long l) {
            this.recordCount = l;
            this.dirty = true;
        }

        public final void incRecordCount() {
            ++this.recordCount;
            this.dirty = true;
        }

        public final void decRecordCount() {
            --this.recordCount;
            this.dirty = true;
        }

        public final long getRecordCount() {
            return this.recordCount;
        }

        private void calculateWorkSize() {
            this.workSize = this.pageSize - this.pageHeaderSize;
        }

        public final int getWorkSize() {
            return this.workSize;
        }
    }
}

