/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.indexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.dbxml.Debug;
import org.dbxml.Stopwatch;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.Record;
import org.dbxml.core.data.RecordSet;
import org.dbxml.core.indexer.CannotCreateException;
import org.dbxml.core.indexer.DuplicateIndexException;
import org.dbxml.core.indexer.IndexPattern;
import org.dbxml.core.indexer.Indexer;
import org.dbxml.server.Configuration;
import org.dbxml.server.ConfigurationCallback;
import org.dbxml.server.SimpleConfigurable;
import org.dbxml.server.dbXMLException;
import org.dbxml.server.util.ObjectStack;
import org.dbxml.xml.NodeSource;
import org.dbxml.xml.SymbolTable;
import org.dbxml.xml.dom.DocumentImpl;
import org.dbxml.xml.sax.CompressionHandler;
import org.dbxml.xml.sax.SAXEventGenerator;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public final class IndexManager
extends SimpleConfigurable {
    private static final String[] EmptyStrings = new String[0];
    private static final IndexerInfo[] EmptyIndexerInfo = new IndexerInfo[0];
    private static final String INDEX = "index";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final int STATUS_READY = 0;
    private static final int STATUS_BUSY = 1;
    private static final int STATUS_DELETED = 2;
    private static final int ACTION_CREATE = 0;
    private static final int ACTION_UPDATE = 1;
    private static final int ACTION_DELETE = 2;
    private static final AutoIndexer autoIndexer = new AutoIndexer();
    private Map patternMap = new HashMap();
    private Map indexes = new HashMap();
    private Map bestIndexers = new HashMap();
    private IndexerInfo[] idxList = EmptyIndexerInfo;
    private Collection collection;
    private SymbolTable symbols;
    private List newIndexers = new ArrayList();

    public IndexManager(Collection collection) {
        this.collection = collection;
        try {
            this.symbols = collection.getSymbols();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public void setConfig(Configuration configuration) throws dbXMLException {
        super.setConfig(configuration);
        try {
            configuration.processChildren(INDEX, new ConfigurationCallback(){

                public void process(Configuration configuration) {
                    String string = configuration.getAttribute(IndexManager.CLASS);
                    try {
                        IndexManager.this.register(Class.forName(string), configuration);
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace((Throwable)exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] list() {
        return this.indexes.keySet().toArray(EmptyStrings);
    }

    public boolean drop(final String string) {
        Indexer indexer = this.get(string);
        this.unregister(string);
        this.config.processChildren(INDEX, new ConfigurationCallback(){

            public void process(Configuration configuration) {
                try {
                    if (configuration.getAttribute(IndexManager.NAME).equals(string)) {
                        configuration.delete();
                    }
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            }
        });
        boolean bl = false;
        try {
            bl = indexer.drop();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public Indexer create(Configuration configuration) throws DBException {
        String string = configuration.getAttribute(CLASS);
        try {
            String string2 = configuration.getAttribute(NAME);
            Configuration[] configurationArray = this.config.getChildren();
            int n = 0;
            while (n < configurationArray.length) {
                if (configurationArray[n].getAttribute(NAME).equals(string2)) {
                    throw new DuplicateIndexException("Duplicate Index '" + string2 + "'");
                }
                ++n;
            }
            Class<?> clazz = Class.forName(string);
            Indexer indexer = this.register(clazz, configuration);
            this.config.add(configuration);
            return indexer;
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (Exception exception) {
            throw new CannotCreateException("Cannot create Index");
        }
    }

    public Indexer register(Class clazz, Configuration configuration) throws DBException {
        String string = null;
        try {
            Indexer indexer = (Indexer)clazz.newInstance();
            this.initialize(indexer, configuration);
            string = indexer.getName();
            if (string == null || string.trim().equals("")) {
                throw new CannotCreateException("No name specified");
            }
            IndexPattern indexPattern = new IndexPattern(this.symbols, indexer.getPattern(), null);
            String string2 = indexer.getIndexStyle();
            IndexerInfo indexerInfo = new IndexerInfo(string, string2, indexPattern, indexer);
            if (!indexer.exists()) {
                indexerInfo.status = 1;
                this.newIndexers.add(indexerInfo);
                autoIndexer.populateIndexers(this);
            } else {
                indexerInfo.status = 0;
                indexer.open();
            }
            this.indexes.put(string, indexerInfo);
            this.patternMap.put(indexPattern, indexerInfo);
            WeakHashMap weakHashMap = (WeakHashMap)this.bestIndexers.get(string2);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap();
                this.bestIndexers.put(string2, weakHashMap);
            }
            weakHashMap.clear();
            this.idxList = this.indexes.values().toArray(EmptyIndexerInfo);
            return indexer;
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (Exception exception) {
            throw new CannotCreateException("Cannot create Index '" + string + "'");
        }
    }

    public void unregister(String string) {
        IndexerInfo indexerInfo = (IndexerInfo)this.indexes.remove(string);
        String string2 = indexerInfo.style;
        this.patternMap.remove(indexerInfo.pattern);
        WeakHashMap weakHashMap = (WeakHashMap)this.bestIndexers.get(string2);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap();
            this.bestIndexers.put(string2, weakHashMap);
        }
        weakHashMap.clear();
        this.idxList = this.indexes.values().toArray(EmptyIndexerInfo);
    }

    private void initialize(Indexer indexer, Configuration configuration) throws dbXMLException {
        indexer.setCollection(this.collection);
        indexer.setConfig(configuration);
    }

    private void populateNewIndexers() throws DBException {
        if (this.newIndexers.size() > 0) {
            IndexerInfo[] indexerInfoArray = this.newIndexers.toArray(EmptyIndexerInfo);
            this.newIndexers.clear();
            int n = 0;
            while (n < indexerInfoArray.length) {
                Debug.println((Object)("Index Creation: " + indexerInfoArray[n].indexer.getName()));
                ++n;
            }
            Stopwatch stopwatch = new Stopwatch("Populated Indexes", true);
            int n2 = 0;
            while (n2 < indexerInfoArray.length) {
                try {
                    if (!indexerInfoArray[n2].indexer.exists()) {
                        indexerInfoArray[n2].indexer.create();
                    }
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
                ++n2;
            }
            RecordSet recordSet = this.collection.getFiler().getRecordSet();
            while (recordSet.hasMoreRecords()) {
                Record record = recordSet.getNextRecord();
                if (record == null) continue;
                Key key = record.getKey();
                DocumentImpl documentImpl = new DocumentImpl(record.getValue().getData(), this.symbols, new NodeSource(this.collection, key));
                try {
                    new SAXHandler(key, documentImpl, 0, indexerInfoArray);
                }
                catch (Exception exception) {
                    Debug.printStackTrace((Throwable)exception);
                }
            }
            stopwatch.stop();
            int n3 = 0;
            while (n3 < indexerInfoArray.length) {
                Debug.println((Object)("Index Complete: " + indexerInfoArray[n3].indexer.getName()));
                ++n3;
            }
            Debug.println((Object)stopwatch.toString());
            n3 = 0;
            while (n3 < indexerInfoArray.length) {
                indexerInfoArray[n3].status = 0;
                ++n3;
            }
        }
    }

    public Indexer get(String string) {
        IndexerInfo indexerInfo = (IndexerInfo)this.indexes.get(string);
        return indexerInfo != null ? indexerInfo.indexer : null;
    }

    public Indexer getBestIndexer(String string, IndexPattern indexPattern) {
        Indexer indexer;
        WeakHashMap<IndexPattern, Indexer> weakHashMap = (WeakHashMap<IndexPattern, Indexer>)this.bestIndexers.get(string);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap<IndexPattern, Indexer>();
            this.bestIndexers.put(string, weakHashMap);
        }
        if ((indexer = (Indexer)weakHashMap.get(indexPattern)) == null) {
            int n = 0;
            Iterator iterator = this.indexes.values().iterator();
            while (iterator.hasNext()) {
                int n2;
                IndexerInfo indexerInfo = (IndexerInfo)iterator.next();
                if (indexerInfo.status != 0 || !indexerInfo.indexer.getIndexStyle().equals(string) || (n2 = indexPattern.getMatchLevel(indexerInfo.pattern)) <= n) continue;
                indexer = indexerInfo.indexer;
                n = n2;
            }
            weakHashMap.put(indexPattern, indexer);
        }
        return indexer;
    }

    public void addDocument(Key key, Document document) {
        if (this.idxList.length > 0) {
            new SAXHandler(key, document, 0);
        }
    }

    public void removeDocument(Key key, Document document) {
        if (this.idxList.length > 0) {
            new SAXHandler(key, document, 2);
        }
    }

    static /* synthetic */ void access$300(IndexManager indexManager) throws DBException {
        indexManager.populateNewIndexers();
    }

    private static class AutoIndexer
    extends Thread {
        public Set mgrSet = new HashSet();

        public AutoIndexer() {
            this.setName("Automatic Indexer");
            this.start();
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block10: while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception var1_2) {
                    // empty catch block
                }
                if (this.mgrSet.isEmpty()) continue;
                var2_3 = this;
                synchronized (var2_3) {
                    var1_1 = new HashSet<E>(this.mgrSet);
                }
                var3_4 = var1_1.iterator();
                while (true) {
                    if (var3_4.hasNext()) ** break;
                    continue block10;
                    var4_6 = (IndexManager)var3_4.next();
                    var5_7 = this;
                    synchronized (var5_7) {
                        this.mgrSet.remove((Object)var4_6);
                    }
                    try {
                        IndexManager.access$300(var4_6);
                    }
                    catch (Exception var6_8) {
                        Debug.printStackTrace((Throwable)var6_8);
                    }
                }
                break;
            }
        }

        public synchronized void populateIndexers(IndexManager indexManager) {
            this.mgrSet.add(indexManager);
        }
    }

    private class StackInfo {
        public short symbolID;
        public StringBuffer sb = null;
        public int pos = -1;
        public int len = -1;

        public StackInfo(short s) {
            this.symbolID = s;
        }
    }

    private class SAXHandler
    implements ContentHandler,
    CompressionHandler {
        private ObjectStack stack = new ObjectStack();
        private IndexerInfo[] list;
        public Key key;
        public Document doc;
        public int action;
        public StackInfo info;

        public SAXHandler(Key key, Document document, int n, IndexerInfo[] indexerInfoArray) {
            this.list = indexerInfoArray;
            this.key = key;
            this.doc = document;
            this.action = n;
            try {
                SAXEventGenerator sAXEventGenerator = new SAXEventGenerator(document);
                sAXEventGenerator.setContentHandler(this);
                sAXEventGenerator.setProperty("CompressionHandler/1.0", this);
                sAXEventGenerator.start();
                if (n == 0 || n == 1) {
                    try {
                        IndexManager.this.collection.flushSymbolTable();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace((Throwable)exception);
            }
        }

        public SAXHandler(Key key, Document document, int n) {
            this(key, document, n, indexManager.idxList);
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
        }

        public void skippedEntity(String string) {
        }

        public void symbols(SymbolTable symbolTable) {
        }

        public void dataBytes(byte[] byArray) {
        }

        public void processEntry(IndexPattern indexPattern, String string, int n, int n2) {
            int n3 = 0;
            while (n3 < this.list.length) {
                if (indexPattern.getMatchLevel(this.list[n3].pattern) > 0) {
                    try {
                        switch (this.action) {
                            case 0: 
                            case 1: {
                                this.list[n3].indexer.add(string, this.key, n, n2, indexPattern.getElementID(), indexPattern.getAttributeID());
                                break;
                            }
                            case 2: {
                                this.list[n3].indexer.remove(string, this.key, n, n2, indexPattern.getElementID(), indexPattern.getAttributeID());
                            }
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace((Throwable)exception);
                    }
                }
                ++n3;
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string != null && string.length() > 0) {
                String string4 = SymbolTable.getNormalizedLocalName(string2, string);
                this.info.symbolID = IndexManager.this.symbols.getSymbol(string4, string, true);
            }
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string5 = attributes.getURI(n2);
                if (string5 != null && string5.length() > 0) {
                    String string6 = "ns" + Integer.toString(string5.hashCode()) + ":" + attributes.getLocalName(n2);
                    short s = IndexManager.this.symbols.getSymbol(string6, string5, true);
                    this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID, s), attributes.getValue(n2), this.info.pos, this.info.len);
                } else {
                    short s = IndexManager.this.symbols.getSymbol(attributes.getQName(n2));
                    this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID, s), attributes.getValue(n2), this.info.pos, this.info.len);
                }
                ++n2;
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (this.info.sb != null) {
                this.processEntry(new IndexPattern(IndexManager.this.symbols, this.info.symbolID), this.info.sb.toString(), this.info.pos, this.info.len);
            }
            this.info = (StackInfo)this.stack.pop();
        }

        public void characters(char[] cArray, int n, int n2) {
            String string = new String(cArray).trim();
            if (this.info.sb == null) {
                this.info.sb = new StringBuffer(cArray.length);
            } else if (this.info.sb.length() > 0) {
                this.info.sb.append(' ');
            }
            this.info.sb.append(string);
        }

        public void symbolID(short s) {
            if (this.info != null) {
                this.stack.push((Object)this.info);
            }
            this.info = new StackInfo(s);
        }

        public void dataLocation(int n, int n2) {
            this.info.pos = n;
            this.info.len = n2;
        }
    }

    private class IndexerInfo {
        public String name;
        public String style;
        public IndexPattern pattern;
        public Indexer indexer;
        public int status;

        public IndexerInfo(String string, String string2, IndexPattern indexPattern, Indexer indexer) {
            this.name = string;
            this.style = string2;
            this.pattern = indexPattern;
            this.indexer = indexer;
        }
    }
}

