/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.indexer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.dbxml.core.filer.Streamable;
import org.dbxml.xml.NamespaceMap;
import org.dbxml.xml.SymbolTable;

public final class IndexPattern
implements Streamable {
    public static final int PATTERN_NONE = -1;
    public static final int PATTERN_WILDCARD = -2;
    public static final int PATTERN_NAME = -3;
    public static final int SCORE_NONE = 0;
    public static final int SCORE_WILDCARD = 1;
    public static final int SCORE_NAME = 2;
    public static final int SCORE_NATURAL = 3;
    private SymbolTable symbols = null;
    private String elemName = null;
    private short elemID = (short)-1;
    private String attrName = null;
    private short attrID = (short)-1;

    public IndexPattern(SymbolTable symbolTable, String string, NamespaceMap namespaceMap) {
        this.symbols = symbolTable;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "@");
        this.elemName = stringTokenizer.nextToken();
        this.elemID = this.elemName.equals("*") ? (short)-2 : SymbolTable.getNormalizedSymbol(symbolTable, this.elemName, namespaceMap, true);
        if (stringTokenizer.hasMoreTokens()) {
            this.attrName = stringTokenizer.nextToken();
            this.attrID = this.attrName.equals("*") ? (short)-2 : (short)(this.elemID == -2 ? -3 : (int)SymbolTable.getNormalizedSymbol(symbolTable, this.attrName, namespaceMap, true));
        }
    }

    public IndexPattern(SymbolTable symbolTable, short s) {
        this.symbols = symbolTable;
        this.elemID = s;
    }

    public IndexPattern(SymbolTable symbolTable, short s, short s2) {
        this.symbols = symbolTable;
        this.elemID = s;
        this.attrID = s2;
    }

    public IndexPattern(SymbolTable symbolTable, short s, String string) {
        this.symbols = symbolTable;
        this.elemID = s;
        this.attrID = (short)-3;
        this.attrName = string;
    }

    public int getMatchLevel(IndexPattern indexPattern) {
        int n = 0;
        switch (indexPattern.elemID) {
            case -2: {
                n = 4;
                break;
            }
            case -3: {
                if (!this.elemName.equals(indexPattern.elemName)) break;
                n = 8;
                break;
            }
            default: {
                if (this.elemID != indexPattern.elemID) break;
                n = 12;
            }
        }
        if (n != 0) {
            switch (indexPattern.attrID) {
                case -2: {
                    return n + 1;
                }
                case -3: {
                    if (!this.attrName.equals(indexPattern.attrName)) break;
                    return n + 2;
                }
                default: {
                    if (this.attrID != indexPattern.attrID) break;
                    return n + 3;
                }
            }
        }
        return 0;
    }

    public short getElementID() {
        return this.elemID;
    }

    public short getAttributeID() {
        return this.attrID;
    }

    public String getElementName() {
        return this.elemName;
    }

    public String getAttributeName() {
        return this.attrName;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        byte[] byArray;
        short s;
        this.elemID = dataInputStream.readShort();
        if (this.elemID == -3) {
            s = dataInputStream.readShort();
            byArray = new byte[s];
            dataInputStream.read(byArray);
            this.elemName = new String(byArray);
        }
        this.attrID = dataInputStream.readShort();
        if (this.attrID == -3) {
            s = dataInputStream.readShort();
            byArray = new byte[s];
            dataInputStream.read(byArray);
            this.attrName = new String(byArray);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray;
        dataOutputStream.writeShort(this.elemID);
        if (this.elemID == -3) {
            byArray = this.elemName.getBytes();
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
        }
        dataOutputStream.writeShort(this.attrID);
        if (this.attrID == -3) {
            byArray = this.attrName.getBytes();
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    public int hashCode() {
        return new Integer((this.elemID << 16) + this.attrID).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof IndexPattern) {
            boolean bl;
            IndexPattern indexPattern = (IndexPattern)object;
            boolean bl2 = bl = this.elemID == indexPattern.elemID && this.attrID == indexPattern.attrID;
            if (bl && (this.elemName != null || indexPattern.elemName != null)) {
                boolean bl3 = bl = this.elemName != null && indexPattern.elemName != null && this.elemName.equals(indexPattern.elemName);
            }
            if (bl && (this.attrName != null || indexPattern.attrName != null)) {
                bl = this.attrName != null && indexPattern.attrName != null && this.attrName.equals(indexPattern.attrName);
            }
            return bl;
        }
        return false;
    }
}

