/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.indexer;

import java.util.Arrays;
import org.dbxml.core.data.Value;
import org.dbxml.core.indexer.IndexPattern;

public class IndexQuery {
    public static final int ANY = 0;
    public static final int EQ = 1;
    public static final int NEQ = -1;
    public static final int GT = 2;
    public static final int LEQ = -2;
    public static final int LT = 3;
    public static final int GEQ = -3;
    public static final int BW = 4;
    public static final int NBW = -4;
    public static final int BWX = 5;
    public static final int NBWX = -5;
    public static final int IN = 6;
    public static final int NIN = -6;
    public static final int SW = 7;
    public static final int NSW = -7;
    protected IndexPattern pattern;
    protected int op;
    protected Value[] vals;

    public IndexQuery(IndexPattern indexPattern) {
        this.pattern = indexPattern;
        this.op = 0;
    }

    public IndexQuery(IndexPattern indexPattern, int n, Value[] valueArray) {
        this.pattern = indexPattern;
        this.op = n;
        this.vals = valueArray;
    }

    public IndexQuery(IndexPattern indexPattern, Value[] valueArray) {
        this(indexPattern, 6, valueArray);
    }

    public IndexQuery(IndexPattern indexPattern, int n, Value value) {
        this.pattern = indexPattern;
        this.op = n;
        if (n == 7 || n == -7) {
            byte[] byArray = new byte[value.getLength() + 1];
            System.arraycopy(value.getData(), 0, byArray, 0, byArray.length - 1);
            byArray[byArray.length - 1] = 127;
            Value value2 = new Value(byArray);
            this.vals = new Value[]{value, value2};
        } else {
            this.vals = new Value[]{value};
        }
    }

    public IndexQuery(IndexPattern indexPattern, Value value) {
        this(indexPattern, 1, value);
    }

    public IndexQuery(IndexPattern indexPattern, int n, Value value, Value value2) {
        this.pattern = indexPattern;
        this.op = n;
        this.vals = new Value[]{value, value2};
    }

    public IndexQuery(IndexPattern indexPattern, Value value, Value value2) {
        this(indexPattern, 6, value, value2);
    }

    public IndexQuery(IndexPattern indexPattern, int n, String string) {
        this(indexPattern, n, new Value(string));
    }

    public IndexQuery(IndexPattern indexPattern, String string) {
        this(indexPattern, new Value(string));
    }

    public IndexQuery(IndexPattern indexPattern, int n, String string, String string2) {
        this(indexPattern, n, new Value(string), new Value(string2));
    }

    public IndexQuery(IndexPattern indexPattern, String string, String string2) {
        this(indexPattern, new Value(string), new Value(string2));
    }

    public IndexPattern getPattern() {
        return this.pattern;
    }

    public int getOperator() {
        return this.op;
    }

    public final Value getValue(int n) {
        return this.vals[n];
    }

    public Value[] getValues() {
        return this.vals;
    }

    public final int getLength() {
        return this.vals.length;
    }

    public boolean testValue(Value value) {
        switch (this.op) {
            case 0: {
                return true;
            }
            case 1: {
                return value.equals(this.vals[0]);
            }
            case -1: {
                return !value.equals(this.vals[0]);
            }
            case 2: {
                return value.compareTo(this.vals[0]) > 0;
            }
            case -2: {
                return value.compareTo(this.vals[0]) <= 0;
            }
            case 3: {
                return value.compareTo(this.vals[0]) < 0;
            }
            case -3: {
                return value.compareTo(this.vals[0]) >= 0;
            }
            case 4: {
                return value.compareTo(this.vals[0]) >= 0 && value.compareTo(this.vals[1]) <= 0;
            }
            case -4: {
                return value.compareTo(this.vals[0]) <= 0 || value.compareTo(this.vals[1]) >= 0;
            }
            case 5: {
                return value.compareTo(this.vals[0]) > 0 && value.compareTo(this.vals[1]) < 0;
            }
            case -5: {
                return value.compareTo(this.vals[0]) < 0 || value.compareTo(this.vals[1]) > 0;
            }
            case -6: 
            case 6: {
                return Arrays.binarySearch(this.vals, value) >= 0 ? this.op == 6 : this.op == -6;
            }
            case -7: 
            case 7: {
                return value.startsWith(this.vals[0]) ? this.op == 7 : this.op == -7;
            }
        }
        return false;
    }

    public final boolean testValue(String string) {
        return this.testValue(new Value(string));
    }
}

