/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.indexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTree;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.BTreeCorruptException;
import org.dbxml.core.filer.Paged;
import org.dbxml.core.indexer.IndexMatch;
import org.dbxml.core.indexer.IndexPattern;
import org.dbxml.core.indexer.IndexQuery;
import org.dbxml.core.indexer.Indexer;
import org.dbxml.server.Configuration;
import org.dbxml.xml.SymbolTable;

public final class NameIndexer
extends BTree
implements Indexer {
    private static final IndexMatch[] EmptyMatches = new IndexMatch[0];
    private static final Value EmptyValue = new Value(new byte[0]);
    private static final byte MATCHES = 20;
    private static final String NAME = "name";
    private static final String PATTERN = "pattern";
    private static final String PAGESIZE = "pagesize";
    private static final String MAXKEYSIZE = "maxkeysize";
    private Configuration config;
    private Collection collection;
    private SymbolTable symbols;
    private String name;
    private String pattern;
    private boolean wildcard = false;
    private Paged.FileHeader fileHeader = this.getFileHeader();

    public void setConfig(Configuration configuration) {
        this.config = configuration;
        try {
            this.name = configuration.getAttribute(NAME);
            this.pattern = configuration.getAttribute(PATTERN);
            this.wildcard = this.pattern.indexOf(42) != -1;
            this.fileHeader.setPageSize(configuration.getIntAttribute(PAGESIZE, this.fileHeader.getPageSize()));
            this.fileHeader.setMaxKeySize(configuration.getShortAttribute(MAXKEYSIZE, this.fileHeader.getMaxKeySize()));
            this.setLocation(this.name);
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(String string) {
        this.setFile(new File(this.collection.getCollectionRoot(), string + ".idx"));
    }

    public void setCollection(Collection collection) {
        try {
            this.collection = collection;
            this.symbols = collection.getSymbols();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public String getIndexStyle() {
        return "Node:Name";
    }

    public String getPattern() {
        return this.pattern;
    }

    public synchronized void remove(String string, Key key, int n, int n2, short s, short s2) throws DBException {
        try {
            this.removeValue(key);
        }
        catch (IOException iOException) {
            throw new BTreeCorruptException("Corruption detected on remove");
        }
    }

    public synchronized void add(String string, Key key, int n, int n2, short s, short s2) throws DBException {
        try {
            this.addValue(key, 0L);
        }
        catch (IOException iOException) {
            throw new BTreeCorruptException("Corruption detected on add");
        }
    }

    public synchronized IndexMatch[] queryMatches(IndexQuery indexQuery) throws DBException {
        final ArrayList arrayList = new ArrayList();
        final IndexPattern indexPattern = indexQuery.getPattern();
        try {
            this.query(indexQuery, new BTreeCallback(){

                public boolean indexInfo(Value value, long l) {
                    arrayList.add(new IndexMatch(new Key(value), indexPattern));
                    return true;
                }
            });
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        return arrayList.toArray(EmptyMatches);
    }
}

