/*
 * Decompiled with CFR 0.152.
 */
package org.dbxml.core.indexer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dbxml.Debug;
import org.dbxml.core.Collection;
import org.dbxml.core.DBException;
import org.dbxml.core.data.Key;
import org.dbxml.core.data.Value;
import org.dbxml.core.filer.BTree;
import org.dbxml.core.filer.BTreeCallback;
import org.dbxml.core.filer.BTreeCorruptException;
import org.dbxml.core.filer.BTreeNotFoundException;
import org.dbxml.core.filer.Paged;
import org.dbxml.core.indexer.IndexMatch;
import org.dbxml.core.indexer.IndexPattern;
import org.dbxml.core.indexer.IndexQuery;
import org.dbxml.core.indexer.Indexer;
import org.dbxml.core.query.QueryEngine;
import org.dbxml.server.Configuration;
import org.dbxml.xml.SymbolTable;

public final class ValueIndexer
extends BTree
implements Indexer {
    private static final IndexMatch[] EmptyMatches = new IndexMatch[0];
    private static final Value EmptyValue = new Value(new byte[0]);
    private static final byte MATCHES = 20;
    private static final long MATCH_INFO = -1000L;
    private static final String NAME = "name";
    private static final String PATTERN = "pattern";
    private static final String TYPE = "type";
    private static final String PAGESIZE = "pagesize";
    private static final String MAXKEYSIZE = "maxkeysize";
    private static final int STRING = 0;
    private static final int SHORT = 1;
    private static final int INT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int BYTE = 6;
    private static final int CHAR = 7;
    private static final int BOOLEAN = 8;
    private static final int TRIMMED = 9;
    private static final int[] sizes = new int[]{-1, 2, 4, 8, 4, 8, 1, 2, 1, -1};
    private static final String STRING_VAL = "string";
    private static final String SHORT_VAL = "short";
    private static final String INT_VAL = "int";
    private static final String LONG_VAL = "long";
    private static final String FLOAT_VAL = "float";
    private static final String DOUBLE_VAL = "double";
    private static final String BYTE_VAL = "byte";
    private static final String CHAR_VAL = "char";
    private static final String BOOLEAN_VAL = "boolean";
    private static final String TRIMMED_VAL = "trimmed";
    private Configuration config;
    private Collection collection;
    private SymbolTable symbols;
    private String name;
    private String pattern;
    private int type;
    private int typeSize = 32;
    private boolean wildcard = false;
    private Paged.FileHeader fileHeader = this.getFileHeader();

    public ValueIndexer() {
        this.fileHeader.setPageSize(1024);
    }

    public void setConfig(Configuration configuration) {
        this.config = configuration;
        try {
            this.name = configuration.getAttribute(NAME);
            this.pattern = configuration.getAttribute(PATTERN);
            this.wildcard = this.pattern.indexOf(42) != -1;
            String string = configuration.getAttribute(TYPE, STRING_VAL).toLowerCase();
            this.type = string.equals(STRING_VAL) ? 0 : (string.equals(TRIMMED_VAL) ? 9 : (string.equals(SHORT_VAL) ? 1 : (string.equals(INT_VAL) ? 2 : (string.equals(LONG_VAL) ? 3 : (string.equals(FLOAT_VAL) ? 4 : (string.equals(DOUBLE_VAL) ? 5 : (string.equals(BYTE_VAL) ? 6 : (string.equals(CHAR_VAL) ? 7 : (string.equals(BOOLEAN_VAL) ? 8 : (this.pattern.indexOf(64) != -1 ? 0 : 9))))))))));
            this.typeSize = sizes[this.type];
            this.fileHeader.setPageSize(configuration.getIntAttribute(PAGESIZE, this.fileHeader.getPageSize()));
            this.fileHeader.setMaxKeySize(configuration.getShortAttribute(MAXKEYSIZE, this.fileHeader.getMaxKeySize()));
            this.setLocation(this.name);
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(String string) {
        this.setFile(new File(this.collection.getCollectionRoot(), string + ".idx"));
    }

    public void setCollection(Collection collection) {
        try {
            this.collection = collection;
            this.symbols = collection.getSymbols();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public String getIndexStyle() {
        return "Node:Value";
    }

    public String getPattern() {
        return this.pattern;
    }

    public Value getTypedValue(String string) {
        if (this.type != 0 && this.type != 9) {
            if ((string = string.trim()).length() == 0) {
                return EmptyValue;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.typeSize);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                switch (this.type) {
                    case 1: {
                        dataOutputStream.writeShort(Short.parseShort(string));
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeInt(Integer.parseInt(string));
                        break;
                    }
                    case 3: {
                        dataOutputStream.writeLong(Long.parseLong(string));
                        break;
                    }
                    case 4: {
                        dataOutputStream.writeFloat(Float.parseFloat(string));
                        break;
                    }
                    case 5: {
                        dataOutputStream.writeDouble(Double.parseDouble(string));
                        break;
                    }
                    case 6: {
                        dataOutputStream.writeByte(Byte.parseByte(string));
                        break;
                    }
                    case 7: {
                        dataOutputStream.writeChar(string.charAt(0));
                        break;
                    }
                    case 8: {
                        if ("[true][yes][1][y][on]".indexOf("[" + string.toString().toLowerCase() + "]") != -1) {
                            dataOutputStream.writeBoolean(true);
                            break;
                        }
                        if ("[false][no][0][n][off]".indexOf("[" + string.toString().toLowerCase() + "]") != -1) {
                            dataOutputStream.writeBoolean(false);
                            break;
                        }
                        return EmptyValue;
                    }
                }
                return new Value(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                return EmptyValue;
            }
        }
        if (this.type == 9) {
            string = QueryEngine.normalizeString(string);
        }
        return new Value(string);
    }

    private Value getCombinedValue(Key key, int n, int n2, short s, short s2) {
        Value value;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(key.getLength() + 13);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(key.getData());
            dataOutputStream.writeByte(0);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeShort(s);
            dataOutputStream.writeShort(s2);
            value = new Value(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            value = null;
        }
        return value;
    }

    private IndexMatch getIndexMatch(Value value) {
        IndexMatch indexMatch;
        try {
            byte[] byArray = value.getData();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            Key key = new Key(byArray, 0, byArray.length - 13);
            dataInputStream.skip(byArray.length - 12);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            indexMatch = new IndexMatch(key, n, n2, s, s2);
        }
        catch (Exception exception) {
            indexMatch = null;
        }
        return indexMatch;
    }

    public synchronized void remove(String string, Key key, int n, int n2, short s, short s2) throws DBException {
        Value value = this.getTypedValue(string);
        if (this.type != 0 && this.type != 9 && value.getLength() == 0) {
            return;
        }
        try {
            BTree.BTreeRootInfo bTreeRootInfo = this.findBTreeRoot(value);
            Value value2 = this.getCombinedValue(key, n, n2, s, s2);
            this.removeValue(bTreeRootInfo, value2);
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public synchronized void add(String string, Key key, int n, int n2, short s, short s2) throws DBException {
        Value value = this.getTypedValue(string);
        if (this.type != 0 && this.type != 9 && value.getLength() == 0) {
            return;
        }
        try {
            BTree.BTreeRootInfo bTreeRootInfo;
            try {
                bTreeRootInfo = this.findBTreeRoot(value);
            }
            catch (BTreeNotFoundException bTreeNotFoundException) {
                bTreeRootInfo = this.createBTreeRoot(value);
            }
            Value value2 = this.getCombinedValue(key, n, n2, s, s2);
            this.addValue(bTreeRootInfo, value2, -1000L);
        }
        catch (DBException dBException) {
            throw dBException;
        }
        catch (IOException iOException) {
            throw new BTreeCorruptException("Corruption detected on add");
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
    }

    public synchronized IndexMatch[] queryMatches(IndexQuery indexQuery) throws DBException {
        Object object;
        if (this.type != 0) {
            object = indexQuery.getValues();
            int n = 0;
            while (n < ((Value[])object).length) {
                object[n] = this.getTypedValue(((Value)object[n]).toString());
                ++n;
            }
        }
        object = new ArrayList();
        try {
            this.query(indexQuery, new BTreeCallback((List)object, indexQuery){
                private final /* synthetic */ List val$results;
                private final /* synthetic */ IndexQuery val$query;
                {
                    this.val$results = list;
                    this.val$query = indexQuery;
                }

                public boolean indexInfo(Value value, long l) {
                    try {
                        if (l == -1000L) {
                            IndexMatch indexMatch = ValueIndexer.this.getIndexMatch(value);
                            if (!ValueIndexer.this.wildcard) {
                                this.val$results.add(indexMatch);
                            } else {
                                IndexPattern indexPattern = new IndexPattern(ValueIndexer.this.symbols, indexMatch.getElement(), indexMatch.getAttribute());
                                if (indexPattern.getMatchLevel(this.val$query.getPattern()) > 0) {
                                    this.val$results.add(indexMatch);
                                }
                            }
                        } else {
                            BTree.BTreeRootInfo bTreeRootInfo = (BTree)ValueIndexer.this.new BTree.BTreeRootInfo(value, l);
                            ValueIndexer.this.query(bTreeRootInfo, null, this);
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace((Throwable)exception);
                        return true;
                    }
                }
            });
        }
        catch (IOException iOException) {
            throw new BTreeCorruptException("Corruption detected on query");
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
        }
        return object.toArray(EmptyMatches);
    }
}

